/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.bk_v4_2_0.bookkeeper.bookie.BufferedChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JournalChannel
implements Closeable {
    static Logger LOG = LoggerFactory.getLogger(JournalChannel.class);
    final FileChannel fc;
    final BufferedChannel bc;
    final int formatVersion;
    long nextPrealloc = 0L;
    final byte[] MAGIC_WORD = "BKLG".getBytes();
    private static final int START_OF_FILE = -12345;
    int HEADER_SIZE = 8;
    int MIN_COMPAT_JOURNAL_FORMAT_VERSION = 1;
    int CURRENT_JOURNAL_FORMAT_VERSION = 4;
    public static final long preAllocSize = 0x400000L;
    public static final ByteBuffer zeros = ByteBuffer.allocate(512);

    JournalChannel(File journalDirectory, long logId) throws IOException {
        this(journalDirectory, logId, -12345L);
    }

    JournalChannel(File journalDirectory, long logId, long position) throws IOException {
        File fn = new File(journalDirectory, Long.toHexString(logId) + ".txn");
        LOG.info("Opening journal {}", (Object)fn);
        if (!fn.exists()) {
            this.fc = new RandomAccessFile(fn, "rw").getChannel();
            this.formatVersion = this.CURRENT_JOURNAL_FORMAT_VERSION;
            ByteBuffer bb = ByteBuffer.allocate(this.HEADER_SIZE);
            bb.put(this.MAGIC_WORD);
            bb.putInt(this.formatVersion);
            bb.flip();
            this.fc.write(bb);
            this.fc.force(true);
            this.bc = new BufferedChannel(this.fc, 65536);
            this.nextPrealloc = 0x400000L;
            this.fc.write(zeros, this.nextPrealloc);
        } else {
            this.fc = new RandomAccessFile(fn, "r").getChannel();
            this.bc = null;
            ByteBuffer bb = ByteBuffer.allocate(this.HEADER_SIZE);
            int c = this.fc.read(bb);
            bb.flip();
            if (c == this.HEADER_SIZE) {
                byte[] first4 = new byte[4];
                bb.get(first4);
                this.formatVersion = Arrays.equals(first4, this.MAGIC_WORD) ? bb.getInt() : 1;
            } else {
                this.formatVersion = 1;
            }
            if (this.formatVersion < this.MIN_COMPAT_JOURNAL_FORMAT_VERSION || this.formatVersion > this.CURRENT_JOURNAL_FORMAT_VERSION) {
                String err = String.format("Invalid journal version, unable to read. Expected between (%d) and (%d), got (%d)", this.MIN_COMPAT_JOURNAL_FORMAT_VERSION, this.CURRENT_JOURNAL_FORMAT_VERSION, this.formatVersion);
                LOG.error(err);
                throw new IOException(err);
            }
            try {
                if (position == -12345L) {
                    if (this.formatVersion >= 2) {
                        this.fc.position(this.HEADER_SIZE);
                    } else {
                        this.fc.position(0L);
                    }
                } else {
                    this.fc.position(position);
                }
            }
            catch (IOException e) {
                LOG.error("Bookie journal file can seek to position :", (Throwable)e);
            }
        }
    }

    int getFormatVersion() {
        return this.formatVersion;
    }

    BufferedChannel getBufferedChannel() throws IOException {
        if (this.bc == null) {
            throw new IOException("Read only journal channel");
        }
        return this.bc;
    }

    void preAllocIfNeeded() throws IOException {
        if (this.bc.position() > this.nextPrealloc) {
            this.nextPrealloc = ((this.fc.size() + (long)this.HEADER_SIZE) / 0x400000L + 1L) * 0x400000L;
            zeros.clear();
            this.fc.write(zeros, this.nextPrealloc);
        }
    }

    int read(ByteBuffer dst) throws IOException {
        return this.fc.read(dst);
    }

    @Override
    public void close() throws IOException {
        this.fc.close();
    }
}

