/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

import java.io.IOException;
import java.util.HashMap;
import org.apache.bk_v4_2_0.bookkeeper.bookie.Bookie;
import org.apache.bk_v4_2_0.bookkeeper.bookie.BookieException;
import org.apache.bk_v4_2_0.bookkeeper.bookie.HandleFactory;
import org.apache.bk_v4_2_0.bookkeeper.bookie.LedgerDescriptor;
import org.apache.bk_v4_2_0.bookkeeper.bookie.LedgerStorage;

class HandleFactoryImpl
implements HandleFactory {
    HashMap<Long, LedgerDescriptor> ledgers = new HashMap();
    HashMap<Long, LedgerDescriptor> readOnlyLedgers = new HashMap();
    final LedgerStorage ledgerStorage;

    HandleFactoryImpl(LedgerStorage ledgerStorage) {
        this.ledgerStorage = ledgerStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LedgerDescriptor getHandle(long ledgerId, byte[] masterKey) throws IOException, BookieException {
        LedgerDescriptor handle = null;
        HashMap<Long, LedgerDescriptor> hashMap = this.ledgers;
        synchronized (hashMap) {
            handle = this.ledgers.get(ledgerId);
            if (handle == null) {
                handle = LedgerDescriptor.create(masterKey, ledgerId, this.ledgerStorage);
                this.ledgers.put(ledgerId, handle);
            }
            handle.checkAccess(masterKey);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LedgerDescriptor getReadOnlyHandle(long ledgerId) throws IOException, Bookie.NoLedgerException {
        LedgerDescriptor handle = null;
        HashMap<Long, LedgerDescriptor> hashMap = this.ledgers;
        synchronized (hashMap) {
            handle = this.readOnlyLedgers.get(ledgerId);
            if (handle == null) {
                handle = LedgerDescriptor.createReadOnly(ledgerId, this.ledgerStorage);
                this.readOnlyLedgers.put(ledgerId, handle);
            }
        }
        return handle;
    }
}

