/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

import bk-shade.com.google.proto_bk_v4_2_0.Message;
import bk-shade.com.google.proto_bk_v4_2_0.TextFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.UnknownHostException;
import org.apache.bk_v4_2_0.bookkeeper.CreateMode;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.ZooDefs;
import org.apache.bk_v4_2_0.bookkeeper.ZooKeeper;
import org.apache.bk_v4_2_0.bookkeeper.bookie.Bookie;
import org.apache.bk_v4_2_0.bookkeeper.bookie.BookieException;
import org.apache.bk_v4_2_0.bookkeeper.conf.ServerConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.data.Stat;
import org.apache.bk_v4_2_0.bookkeeper.proto.DataFormats;
import org.apache.bk_v4_2_0.bookkeeper.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Cookie {
    static Logger LOG = LoggerFactory.getLogger(Cookie.class);
    static final int CURRENT_COOKIE_LAYOUT_VERSION = 4;
    private int layoutVersion = 0;
    private String bookieHost = null;
    private String journalDir = null;
    private String ledgerDirs = null;
    private int znodeVersion = -1;
    private String instanceId = null;

    private Cookie() {
    }

    public void verify(Cookie c) throws BookieException.InvalidCookieException {
        if (c.layoutVersion < 3 && c.layoutVersion != this.layoutVersion) {
            String errMsg = "Cookie is of too old version " + c.layoutVersion;
            LOG.error(errMsg);
            throw new BookieException.InvalidCookieException(errMsg);
        }
        if (!(c.layoutVersion >= 3 && c.bookieHost.equals(this.bookieHost) && c.journalDir.equals(this.journalDir) && c.ledgerDirs.equals(this.ledgerDirs))) {
            String errMsg = "Cookie [" + this + "] is not matching with [" + c + "]";
            throw new BookieException.InvalidCookieException(errMsg);
        }
        if (this.instanceId == null && c.instanceId != null || this.instanceId != null && !this.instanceId.equals(c.instanceId)) {
            String errMsg = "instanceId " + this.instanceId + " is not matching with " + c.instanceId;
            throw new BookieException.InvalidCookieException(errMsg);
        }
    }

    public String toString() {
        if (this.layoutVersion <= 3) {
            return this.toStringVersion3();
        }
        DataFormats.CookieFormat.Builder builder = DataFormats.CookieFormat.newBuilder();
        builder.setBookieHost(this.bookieHost);
        builder.setJournalDir(this.journalDir);
        builder.setLedgerDirs(this.ledgerDirs);
        if (null != this.instanceId) {
            builder.setInstanceId(this.instanceId);
        }
        StringBuilder b = new StringBuilder();
        b.append(4).append("\n");
        b.append(TextFormat.printToString(builder.build()));
        return b.toString();
    }

    private String toStringVersion3() {
        StringBuilder b = new StringBuilder();
        b.append(4).append("\n").append(this.bookieHost).append("\n").append(this.journalDir).append("\n").append(this.ledgerDirs).append("\n");
        return b.toString();
    }

    private static Cookie parse(BufferedReader reader) throws IOException {
        Cookie c = new Cookie();
        String line = reader.readLine();
        if (null == line) {
            throw new EOFException("Exception in parsing cookie");
        }
        try {
            c.layoutVersion = Integer.parseInt(line.trim());
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid string '" + line.trim() + "', cannot parse cookie.");
        }
        if (c.layoutVersion == 3) {
            c.bookieHost = reader.readLine();
            c.journalDir = reader.readLine();
            c.ledgerDirs = reader.readLine();
        } else if (c.layoutVersion >= 4) {
            DataFormats.CookieFormat.Builder builder = DataFormats.CookieFormat.newBuilder();
            TextFormat.merge(reader, (Message.Builder)builder);
            DataFormats.CookieFormat data = builder.build();
            c.bookieHost = data.getBookieHost();
            c.journalDir = data.getJournalDir();
            c.ledgerDirs = data.getLedgerDirs();
            if (null != data.getInstanceId() && !data.getInstanceId().isEmpty()) {
                c.instanceId = data.getInstanceId();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToDirectory(File directory) throws IOException {
        File versionFile = new File(directory, "VERSION");
        FileOutputStream fos = new FileOutputStream(versionFile);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            bw.write(this.toString());
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            fos.close();
        }
    }

    void writeToZooKeeper(ZooKeeper zk, ServerConfiguration conf) throws KeeperException, InterruptedException, UnknownHostException {
        String bookieCookiePath = conf.getZkLedgersRootPath() + "/" + "cookies";
        String zkPath = Cookie.getZkPath(conf);
        byte[] data = this.toString().getBytes();
        if (this.znodeVersion != -1) {
            zk.setData(zkPath, data, this.znodeVersion);
        } else {
            if (zk.exists(bookieCookiePath, false) == null) {
                try {
                    zk.create(bookieCookiePath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nne) {
                    LOG.info("More than one bookie tried to create {} at once. Safe to ignore", (Object)bookieCookiePath);
                }
            }
            zk.create(zkPath, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Stat stat = zk.exists(zkPath, false);
            this.znodeVersion = stat.getVersion();
        }
    }

    void deleteFromZooKeeper(ZooKeeper zk, ServerConfiguration conf) throws KeeperException, InterruptedException, UnknownHostException {
        String zkPath = Cookie.getZkPath(conf);
        if (this.znodeVersion != -1) {
            zk.delete(zkPath, this.znodeVersion);
        }
        this.znodeVersion = -1;
    }

    static Cookie generateCookie(ServerConfiguration conf) throws UnknownHostException {
        Cookie c = new Cookie();
        c.layoutVersion = 4;
        c.bookieHost = StringUtils.addrToString(Bookie.getBookieAddress(conf));
        c.journalDir = conf.getJournalDirName();
        StringBuilder b = new StringBuilder();
        String[] dirs = conf.getLedgerDirNames();
        b.append(dirs.length);
        for (String d : dirs) {
            b.append("\t").append(d);
        }
        c.ledgerDirs = b.toString();
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Cookie readFromZooKeeper(ZooKeeper zk, ServerConfiguration conf) throws KeeperException, InterruptedException, IOException, UnknownHostException {
        String zkPath = Cookie.getZkPath(conf);
        Stat stat = zk.exists(zkPath, false);
        byte[] data = zk.getData(zkPath, false, stat);
        BufferedReader reader = new BufferedReader(new StringReader(new String(data)));
        try {
            Cookie c = Cookie.parse(reader);
            c.znodeVersion = stat.getVersion();
            Cookie cookie = c;
            return cookie;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Cookie readFromDirectory(File directory) throws IOException {
        File versionFile = new File(directory, "VERSION");
        BufferedReader reader = new BufferedReader(new FileReader(versionFile));
        try {
            Cookie cookie = Cookie.parse(reader);
            return cookie;
        }
        finally {
            reader.close();
        }
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    private static String getZkPath(ServerConfiguration conf) throws UnknownHostException {
        String bookieCookiePath = conf.getZkLedgersRootPath() + "/" + "cookies";
        return bookieCookiePath + "/" + StringUtils.addrToString(Bookie.getBookieAddress(conf));
    }
}

