/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper;

import java.util.List;
import org.apache.bk_v4_2_0.bookkeeper.CreateMode;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.MultiTransactionRecord;
import org.apache.bk_v4_2_0.bookkeeper.Op;
import org.apache.bk_v4_2_0.bookkeeper.OpResult;
import org.apache.bk_v4_2_0.bookkeeper.ZooKeeper;
import org.apache.bk_v4_2_0.bookkeeper.data.ACL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction {
    private ZooKeeper zk;
    private MultiTransactionRecord request = new MultiTransactionRecord();

    protected Transaction(ZooKeeper zk) {
        this.zk = zk;
    }

    public Transaction create(String path, byte[] data, List<ACL> acl, CreateMode createMode) {
        this.request.add(Op.create(path, data, acl, createMode.toFlag()));
        return this;
    }

    public Transaction delete(String path, int version) {
        this.request.add(Op.delete(path, version));
        return this;
    }

    public Transaction check(String path, int version) {
        this.request.add(Op.check(path, version));
        return this;
    }

    public Transaction setData(String path, byte[] data, int version) {
        this.request.add(Op.setData(path, data, version));
        return this;
    }

    public List<OpResult> commit() throws InterruptedException, KeeperException {
        return this.zk.multiInternal(this.request);
    }
}

