/*
 * Decompiled with CFR 0.152.
 */
package com.google.bk_v4_2_0.common.reflect;

import com.google.bk_v4_2_0.common.annotations.Beta;
import com.google.bk_v4_2_0.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

@Beta
public final class Reflection {
    public static String getPackageName(Class<?> cls) {
        return Reflection.getPackageName(cls.getName());
    }

    public static String getPackageName(String classFullName) {
        int lastDot = classFullName.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return classFullName.substring(0, lastDot);
    }

    public static void initialize(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static <T> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(handler);
        Preconditions.checkArgument(interfaceType.isInterface());
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(object);
    }

    private Reflection() {
    }
}

