/*
 * Decompiled with CFR 0.152.
 */
package com.google.bk_v4_2_0.common.eventbus;

import com.google.bk_v4_2_0.common.collect.HashMultimap;
import com.google.bk_v4_2_0.common.collect.Multimap;
import com.google.bk_v4_2_0.common.eventbus.AllowConcurrentEvents;
import com.google.bk_v4_2_0.common.eventbus.EventHandler;
import com.google.bk_v4_2_0.common.eventbus.HandlerFindingStrategy;
import com.google.bk_v4_2_0.common.eventbus.Subscribe;
import com.google.bk_v4_2_0.common.eventbus.SynchronizedEventHandler;
import com.google.bk_v4_2_0.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Set;

class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap<Class<?>, EventHandler> findAllHandlers(Object listener) {
        HashMultimap<Class<?>, EventHandler> methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        Set supers = TypeToken.of(clazz).getTypes().rawTypes();
        block2: for (Method method : clazz.getMethods()) {
            for (Class c : supers) {
                try {
                    Method m = c.getMethod(method.getName(), method.getParameterTypes());
                    if (!m.isAnnotationPresent(Subscribe.class)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1) {
                        throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but requires " + parameterTypes.length + " arguments.  Event handler methods must require a single argument.");
                    }
                    Class<?> eventType = parameterTypes[0];
                    EventHandler handler = AnnotatedHandlerFinder.makeHandler(listener, method);
                    methodsInListener.put(eventType, handler);
                    continue block2;
                }
                catch (NoSuchMethodException ignored) {
                }
            }
        }
        return methodsInListener;
    }

    private static EventHandler makeHandler(Object listener, Method method) {
        EventHandler wrapper = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(listener, method) : new SynchronizedEventHandler(listener, method);
        return wrapper;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }
}

