/*
 * Decompiled with CFR 0.152.
 */
package com.google.bk_v4_2_0.common.collect;

import com.google.bk_v4_2_0.common.annotations.GwtCompatible;
import com.google.bk_v4_2_0.common.annotations.GwtIncompatible;
import com.google.bk_v4_2_0.common.collect.ImmutableCollection;
import com.google.bk_v4_2_0.common.collect.ImmutableSet;
import com.google.bk_v4_2_0.common.collect.ObjectArrays;
import com.google.bk_v4_2_0.common.collect.Sets;
import com.google.bk_v4_2_0.common.collect.UnmodifiableIterator;
import java.util.Iterator;

@GwtCompatible(emulated=true)
abstract class TransformedImmutableSet<D, E>
extends ImmutableSet<E> {
    final ImmutableCollection<D> source;
    final int hashCode;

    TransformedImmutableSet(ImmutableCollection<D> source) {
        this.source = source;
        this.hashCode = Sets.hashCodeImpl(this);
    }

    TransformedImmutableSet(ImmutableCollection<D> source, int hashCode) {
        this.source = source;
        this.hashCode = hashCode;
    }

    abstract E transform(D var1);

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        final Iterator backingIterator = this.source.iterator();
        return new UnmodifiableIterator<E>(){

            @Override
            public boolean hasNext() {
                return backingIterator.hasNext();
            }

            @Override
            public E next() {
                return TransformedImmutableSet.this.transform(backingIterator.next());
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return ObjectArrays.toArrayImpl(this, array);
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    @GwtIncompatible(value="unused")
    boolean isHashCodeFast() {
        return true;
    }
}

