/*
 * Decompiled with CFR 0.152.
 */
package com.google.bk_v4_2_0.common.collect;

import com.google.bk_v4_2_0.common.base.Preconditions;
import com.google.bk_v4_2_0.common.collect.BoundType;
import com.google.bk_v4_2_0.common.collect.ImmutableList;
import com.google.bk_v4_2_0.common.collect.ImmutableSet;
import com.google.bk_v4_2_0.common.collect.ImmutableSortedMultiset;
import com.google.bk_v4_2_0.common.collect.ImmutableSortedSet;
import com.google.bk_v4_2_0.common.collect.Iterators;
import com.google.bk_v4_2_0.common.collect.Multiset;
import com.google.bk_v4_2_0.common.collect.ObjectArrays;
import com.google.bk_v4_2_0.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Comparator;
import javax.annotation.Nullable;

final class EmptyImmutableSortedMultiset<E>
extends ImmutableSortedMultiset<E> {
    private final ImmutableSortedSet<E> elementSet;

    EmptyImmutableSortedMultiset(Comparator<? super E> comparator) {
        this.elementSet = ImmutableSortedSet.emptySet(comparator);
    }

    @Override
    public Multiset.Entry<E> firstEntry() {
        return null;
    }

    @Override
    public Multiset.Entry<E> lastEntry() {
        return null;
    }

    @Override
    public int count(@Nullable Object element) {
        return 0;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> targets) {
        return targets.isEmpty();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public ImmutableSortedSet<E> elementSet() {
        return this.elementSet;
    }

    @Override
    public ImmutableSet<Multiset.Entry<E>> entrySet() {
        return ImmutableSet.of();
    }

    @Override
    ImmutableSet<Multiset.Entry<E>> createEntrySet() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableSortedMultiset<E> headMultiset(E upperBound, BoundType boundType) {
        Preconditions.checkNotNull(upperBound);
        Preconditions.checkNotNull(boundType);
        return this;
    }

    @Override
    public ImmutableSortedMultiset<E> tailMultiset(E lowerBound, BoundType boundType) {
        Preconditions.checkNotNull(lowerBound);
        Preconditions.checkNotNull(boundType);
        return this;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.emptyIterator();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Multiset) {
            Multiset other = (Multiset)object;
            return other.isEmpty();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.EMPTY_ARRAY;
    }

    @Override
    public <T> T[] toArray(T[] other) {
        return this.asList().toArray(other);
    }

    @Override
    public ImmutableList<E> asList() {
        return ImmutableList.of();
    }
}

