/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bk_v4_2_0.netty.handler.codec.compression;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffer;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffers;
import org.jboss.bk_v4_2_0.netty.channel.Channel;
import org.jboss.bk_v4_2_0.netty.channel.ChannelEvent;
import org.jboss.bk_v4_2_0.netty.channel.ChannelFuture;
import org.jboss.bk_v4_2_0.netty.channel.ChannelFutureListener;
import org.jboss.bk_v4_2_0.netty.channel.ChannelHandlerContext;
import org.jboss.bk_v4_2_0.netty.channel.ChannelStateEvent;
import org.jboss.bk_v4_2_0.netty.channel.Channels;
import org.jboss.bk_v4_2_0.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.bk_v4_2_0.netty.handler.codec.compression.ZlibUtil;
import org.jboss.bk_v4_2_0.netty.handler.codec.compression.ZlibWrapper;
import org.jboss.bk_v4_2_0.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.bk_v4_2_0.netty.util.internal.jzlib.JZlib;
import org.jboss.bk_v4_2_0.netty.util.internal.jzlib.ZStream;

public class ZlibEncoder
extends OneToOneEncoder
implements LifeCycleAwareChannelHandler {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final ZStream z = new ZStream();
    private final AtomicBoolean finished = new AtomicBoolean();
    private volatile ChannelHandlerContext ctx;

    public ZlibEncoder() {
        this(6);
    }

    public ZlibEncoder(int compressionLevel) {
        this(ZlibWrapper.ZLIB, compressionLevel);
    }

    public ZlibEncoder(ZlibWrapper wrapper) {
        this(wrapper, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZlibEncoder(ZlibWrapper wrapper, int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        if (wrapper == null) {
            throw new NullPointerException("wrapper");
        }
        ZStream zStream = this.z;
        synchronized (zStream) {
            int resultCode = this.z.deflateInit(compressionLevel, ZlibUtil.convertWrapperType(wrapper));
            if (resultCode != 0) {
                ZlibUtil.fail(this.z, "initialization failure", resultCode);
            }
        }
    }

    public ZlibEncoder(byte[] dictionary) {
        this(6, dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZlibEncoder(int compressionLevel, byte[] dictionary) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        if (dictionary == null) {
            throw new NullPointerException("dictionary");
        }
        ZStream zStream = this.z;
        synchronized (zStream) {
            int resultCode = this.z.deflateInit(compressionLevel, JZlib.W_ZLIB);
            if (resultCode != 0) {
                ZlibUtil.fail(this.z, "initialization failure", resultCode);
            } else {
                resultCode = this.z.deflateSetDictionary(dictionary, dictionary.length);
                if (resultCode != 0) {
                    ZlibUtil.fail(this.z, "failed to set the dictionary", resultCode);
                }
            }
        }
    }

    public ChannelFuture close() {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return this.finishEncode(ctx, null);
    }

    public boolean isClosed() {
        return this.finished.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        ChannelBuffer result;
        if (!(msg instanceof ChannelBuffer) || this.finished.get()) {
            return msg;
        }
        ZStream zStream = this.z;
        synchronized (zStream) {
            try {
                ChannelBuffer uncompressed = (ChannelBuffer)msg;
                byte[] in = new byte[uncompressed.readableBytes()];
                uncompressed.readBytes(in);
                this.z.next_in = in;
                this.z.next_in_index = 0;
                this.z.avail_in = in.length;
                byte[] out = new byte[(int)Math.ceil((double)in.length * 1.001) + 12];
                this.z.next_out = out;
                this.z.next_out_index = 0;
                this.z.avail_out = out.length;
                int resultCode = this.z.deflate(2);
                if (resultCode != 0) {
                    ZlibUtil.fail(this.z, "compression failure", resultCode);
                }
                result = this.z.next_out_index != 0 ? ctx.getChannel().getConfig().getBufferFactory().getBuffer(uncompressed.order(), out, 0, this.z.next_out_index) : ChannelBuffers.EMPTY_BUFFER;
            }
            finally {
                this.z.next_in = null;
                this.z.next_out = null;
            }
        }
        return result;
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (evt instanceof ChannelStateEvent) {
            ChannelStateEvent e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    this.finishEncode(ctx, evt);
                    return;
                }
            }
        }
        super.handleDownstream(ctx, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture finishEncode(final ChannelHandlerContext ctx, final ChannelEvent evt) {
        ChannelBuffer footer;
        ChannelFuture future;
        if (!this.finished.compareAndSet(false, true)) {
            if (evt != null) {
                ctx.sendDownstream(evt);
            }
            return Channels.succeededFuture(ctx.getChannel());
        }
        ZStream zStream = this.z;
        synchronized (zStream) {
            try {
                this.z.next_in = EMPTY_ARRAY;
                this.z.next_in_index = 0;
                this.z.avail_in = 0;
                byte[] out = new byte[32];
                this.z.next_out = out;
                this.z.next_out_index = 0;
                this.z.avail_out = out.length;
                int resultCode = this.z.deflate(4);
                if (resultCode != 0 && resultCode != 1) {
                    future = Channels.failedFuture(ctx.getChannel(), ZlibUtil.exception(this.z, "compression failure", resultCode));
                    footer = null;
                } else if (this.z.next_out_index != 0) {
                    future = Channels.future(ctx.getChannel());
                    footer = ctx.getChannel().getConfig().getBufferFactory().getBuffer(out, 0, this.z.next_out_index);
                } else {
                    future = Channels.future(ctx.getChannel());
                    footer = ChannelBuffers.EMPTY_BUFFER;
                }
            }
            finally {
                this.z.deflateEnd();
                this.z.next_in = null;
                this.z.next_out = null;
            }
        }
        if (footer != null) {
            Channels.write(ctx, future, footer);
        }
        if (evt != null) {
            future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ctx.sendDownstream(evt);
                }
            });
        }
        return future;
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }
}

