/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bk_v4_2_0.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import org.jboss.bk_v4_2_0.netty.channel.ChannelPipeline;
import org.jboss.bk_v4_2_0.netty.channel.socket.DatagramChannel;
import org.jboss.bk_v4_2_0.netty.channel.socket.DatagramChannelFactory;
import org.jboss.bk_v4_2_0.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.bk_v4_2_0.netty.channel.socket.nio.NioDatagramPipelineSink;
import org.jboss.bk_v4_2_0.netty.channel.socket.nio.SelectorUtil;
import org.jboss.bk_v4_2_0.netty.util.internal.ExecutorUtil;

public class NioDatagramChannelFactory
implements DatagramChannelFactory {
    private final Executor workerExecutor;
    private final NioDatagramPipelineSink sink;

    public NioDatagramChannelFactory(Executor workerExecutor) {
        this(workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioDatagramChannelFactory(Executor workerExecutor, int workerCount) {
        if (workerCount <= 0) {
            throw new IllegalArgumentException(String.format("workerCount (%s) must be a positive integer.", workerCount));
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor argument must not be null");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new NioDatagramPipelineSink(workerExecutor, workerCount);
    }

    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new NioDatagramChannel(this, pipeline, this.sink, this.sink.nextWorker());
    }

    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

