/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bk_v4_2_0.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffer;
import org.jboss.bk_v4_2_0.netty.channel.AbstractChannel;
import org.jboss.bk_v4_2_0.netty.channel.ChannelException;
import org.jboss.bk_v4_2_0.netty.channel.ChannelFactory;
import org.jboss.bk_v4_2_0.netty.channel.ChannelFuture;
import org.jboss.bk_v4_2_0.netty.channel.ChannelPipeline;
import org.jboss.bk_v4_2_0.netty.channel.ChannelSink;
import org.jboss.bk_v4_2_0.netty.channel.Channels;
import org.jboss.bk_v4_2_0.netty.channel.MessageEvent;
import org.jboss.bk_v4_2_0.netty.channel.socket.DatagramChannel;
import org.jboss.bk_v4_2_0.netty.channel.socket.nio.DefaultNioDatagramChannelConfig;
import org.jboss.bk_v4_2_0.netty.channel.socket.nio.NioDatagramChannelConfig;
import org.jboss.bk_v4_2_0.netty.channel.socket.nio.NioDatagramWorker;
import org.jboss.bk_v4_2_0.netty.channel.socket.nio.SocketSendBufferPool;
import org.jboss.bk_v4_2_0.netty.util.internal.LinkedTransferQueue;
import org.jboss.bk_v4_2_0.netty.util.internal.ThreadLocalBoolean;

class NioDatagramChannel
extends AbstractChannel
implements DatagramChannel {
    private final NioDatagramChannelConfig config;
    final NioDatagramWorker worker;
    private final java.nio.channels.DatagramChannel datagramChannel;
    final Object interestOpsLock = new Object();
    final Object writeLock = new Object();
    final Runnable writeTask = new WriteTask();
    final AtomicBoolean writeTaskInTaskQueue = new AtomicBoolean();
    final Queue<MessageEvent> writeBufferQueue = new WriteRequestQueue();
    final AtomicInteger writeBufferSize = new AtomicInteger();
    final AtomicInteger highWaterMarkCounter = new AtomicInteger();
    MessageEvent currentWriteEvent;
    SocketSendBufferPool.SendBuffer currentWriteBuffer;
    boolean inWriteNowLoop;
    boolean writeSuspended;
    private volatile InetSocketAddress localAddress;
    volatile InetSocketAddress remoteAddress;

    NioDatagramChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NioDatagramWorker worker) {
        super(null, factory, pipeline, sink);
        this.worker = worker;
        this.datagramChannel = this.openNonBlockingChannel();
        this.config = new DefaultNioDatagramChannelConfig(this.datagramChannel.socket());
        Channels.fireChannelOpen(this);
    }

    private java.nio.channels.DatagramChannel openNonBlockingChannel() {
        try {
            java.nio.channels.DatagramChannel channel = java.nio.channels.DatagramChannel.open();
            channel.configureBlocking(false);
            return channel;
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a DatagramChannel.", e);
        }
    }

    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                this.localAddress = localAddress = (InetSocketAddress)this.datagramChannel.socket().getLocalSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = (InetSocketAddress)this.datagramChannel.socket().getRemoteSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    public boolean isBound() {
        return this.isOpen() && this.datagramChannel.socket().isBound();
    }

    public boolean isConnected() {
        return this.datagramChannel.isConnected();
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    public NioDatagramChannelConfig getConfig() {
        return this.config;
    }

    java.nio.channels.DatagramChannel getDatagramChannel() {
        return this.datagramChannel;
    }

    public int getInterestOps() {
        int highWaterMark;
        int lowWaterMark;
        if (!this.isOpen()) {
            return 4;
        }
        int interestOps = this.getRawInterestOps();
        int writeBufferSize = this.writeBufferSize.get();
        interestOps = writeBufferSize != 0 ? (this.highWaterMarkCounter.get() > 0 ? (writeBufferSize >= (lowWaterMark = this.getConfig().getWriteBufferLowWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB)) : (writeBufferSize >= (highWaterMark = this.getConfig().getWriteBufferHighWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB))) : (interestOps &= 0xFFFFFFFB);
        return interestOps;
    }

    int getRawInterestOps() {
        return super.getInterestOps();
    }

    void setRawInterestOpsNow(int interestOps) {
        super.setInterestOpsNow(interestOps);
    }

    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return super.write(message, remoteAddress);
    }

    public void joinGroup(InetAddress multicastAddress) {
        throw new UnsupportedOperationException();
    }

    public void joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        throw new UnsupportedOperationException();
    }

    public void leaveGroup(InetAddress multicastAddress) {
        throw new UnsupportedOperationException();
    }

    public void leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        throw new UnsupportedOperationException();
    }

    private final class WriteTask
    implements Runnable {
        WriteTask() {
        }

        public void run() {
            NioDatagramChannel.this.writeTaskInTaskQueue.set(false);
            NioDatagramChannel.this.worker.writeFromTaskLoop(NioDatagramChannel.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WriteRequestQueue
    extends LinkedTransferQueue<MessageEvent> {
        private static final long serialVersionUID = 5057413071460766376L;
        private final ThreadLocalBoolean notifying = new ThreadLocalBoolean();

        WriteRequestQueue() {
        }

        @Override
        public boolean offer(MessageEvent e) {
            int highWaterMark;
            boolean success = super.offer(e);
            assert (success);
            int messageSize = this.getMessageSize(e);
            int newWriteBufferSize = NioDatagramChannel.this.writeBufferSize.addAndGet(messageSize);
            if (newWriteBufferSize >= (highWaterMark = NioDatagramChannel.this.getConfig().getWriteBufferHighWaterMark()) && newWriteBufferSize - messageSize < highWaterMark) {
                NioDatagramChannel.this.highWaterMarkCounter.incrementAndGet();
                if (!((Boolean)this.notifying.get()).booleanValue()) {
                    this.notifying.set(Boolean.TRUE);
                    Channels.fireChannelInterestChanged(NioDatagramChannel.this);
                    this.notifying.set(Boolean.FALSE);
                }
            }
            return true;
        }

        @Override
        public MessageEvent poll() {
            MessageEvent e = (MessageEvent)super.poll();
            if (e != null) {
                int messageSize = this.getMessageSize(e);
                int newWriteBufferSize = NioDatagramChannel.this.writeBufferSize.addAndGet(-messageSize);
                int lowWaterMark = NioDatagramChannel.this.getConfig().getWriteBufferLowWaterMark();
                if ((newWriteBufferSize == 0 || newWriteBufferSize < lowWaterMark) && newWriteBufferSize + messageSize >= lowWaterMark) {
                    NioDatagramChannel.this.highWaterMarkCounter.decrementAndGet();
                    if (NioDatagramChannel.this.isBound() && !((Boolean)this.notifying.get()).booleanValue()) {
                        this.notifying.set(Boolean.TRUE);
                        Channels.fireChannelInterestChanged(NioDatagramChannel.this);
                        this.notifying.set(Boolean.FALSE);
                    }
                }
            }
            return e;
        }

        private int getMessageSize(MessageEvent e) {
            Object m = e.getMessage();
            if (m instanceof ChannelBuffer) {
                return ((ChannelBuffer)m).readableBytes();
            }
            return 0;
        }
    }
}

