/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.commons.configuration.tree;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bk_v4_2_0.commons.configuration.tree.ConfigurationNode;
import org.apache.bk_v4_2_0.commons.configuration.tree.NodeCombiner;
import org.apache.bk_v4_2_0.commons.configuration.tree.ViewNode;

public class UnionCombiner
extends NodeCombiner {
    public ConfigurationNode combine(ConfigurationNode node1, ConfigurationNode node2) {
        ViewNode result = this.createViewNode();
        result.setName(node1.getName());
        result.appendAttributes(node1);
        result.appendAttributes(node2);
        LinkedList children2 = new LinkedList(node2.getChildren());
        Iterator it = node1.getChildren().iterator();
        while (it.hasNext()) {
            ConfigurationNode child1 = (ConfigurationNode)it.next();
            ConfigurationNode child2 = this.findCombineNode(node1, node2, child1, children2);
            if (child2 != null) {
                result.addChild(this.combine(child1, child2));
                children2.remove(child2);
                continue;
            }
            result.addChild(child1);
        }
        it = children2.iterator();
        while (it.hasNext()) {
            result.addChild((ConfigurationNode)it.next());
        }
        return result;
    }

    protected ConfigurationNode findCombineNode(ConfigurationNode node1, ConfigurationNode node2, ConfigurationNode child, List children) {
        ConfigurationNode child2;
        if (child.getValue() == null && !this.isListNode(child) && node1.getChildrenCount(child.getName()) == 1 && node2.getChildrenCount(child.getName()) == 1 && (child2 = (ConfigurationNode)node2.getChildren(child.getName()).iterator().next()).getValue() == null) {
            return child2;
        }
        return null;
    }
}

