/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.commons.configuration.reloading;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.bk_v4_2_0.commons.configuration.ConfigurationUtils;
import org.apache.bk_v4_2_0.commons.configuration.FileConfiguration;
import org.apache.bk_v4_2_0.commons.configuration.reloading.ReloadingStrategy;

public class FileChangedReloadingStrategy
implements ReloadingStrategy {
    private static final String JAR_PROTOCOL = "jar";
    private static final int DEFAULT_REFRESH_DELAY = 5000;
    protected FileConfiguration configuration;
    protected long lastModified;
    protected long lastChecked;
    protected long refreshDelay = 5000L;
    private boolean reloading;

    public void setConfiguration(FileConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        this.updateLastModified();
    }

    public boolean reloadingRequired() {
        long now;
        if (!this.reloading && (now = System.currentTimeMillis()) > this.lastChecked + this.refreshDelay) {
            this.lastChecked = now;
            if (this.hasChanged()) {
                this.reloading = true;
            }
        }
        return this.reloading;
    }

    public void reloadingPerformed() {
        this.updateLastModified();
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(long refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    protected void updateLastModified() {
        File file = this.getFile();
        if (file != null) {
            this.lastModified = file.lastModified();
        }
        this.reloading = false;
    }

    protected boolean hasChanged() {
        File file = this.getFile();
        if (file == null || !file.exists()) {
            return false;
        }
        return file.lastModified() > this.lastModified;
    }

    protected File getFile() {
        return this.configuration.getURL() != null ? this.fileFromURL(this.configuration.getURL()) : this.configuration.getFile();
    }

    private File fileFromURL(URL url) {
        if (JAR_PROTOCOL.equals(url.getProtocol())) {
            String path = url.getPath();
            try {
                return ConfigurationUtils.fileFromURL(new URL(path.substring(0, path.indexOf(33))));
            }
            catch (MalformedURLException mex) {
                return null;
            }
        }
        return ConfigurationUtils.fileFromURL(url);
    }
}

