/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.util;

import java.io.IOException;
import java.net.InetSocketAddress;

public class StringUtils {
    public static final String LEDGER_NODE_PREFIX = "L";

    public static InetSocketAddress parseAddr(String s) throws IOException {
        int port;
        String[] parts = s.split(":");
        if (parts.length != 2) {
            throw new IOException(s + " does not have the form host:port");
        }
        try {
            port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(s + " does not have the form host:port");
        }
        InetSocketAddress addr = new InetSocketAddress(parts[0], port);
        return addr;
    }

    public static String addrToString(InetSocketAddress addr) {
        return addr.getAddress().getHostAddress() + ":" + addr.getPort();
    }

    public static String getZKStringId(long id) {
        return String.format("%010d", id);
    }

    public static String getHierarchicalLedgerPath(long ledgerId) {
        String ledgerIdStr = StringUtils.getZKStringId(ledgerId);
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(ledgerIdStr.substring(0, 2)).append("/").append(ledgerIdStr.substring(2, 6)).append("/").append(LEDGER_NODE_PREFIX).append(ledgerIdStr.substring(6, 10));
        return sb.toString();
    }

    public static long stringToHierarchicalLedgerId(String hierarchicalLedgerPath) throws IOException {
        String[] hierarchicalParts = hierarchicalLedgerPath.split("/");
        if (hierarchicalParts.length != 3) {
            throw new IOException("it is not a valid hierarchical path name : " + hierarchicalLedgerPath);
        }
        hierarchicalParts[2] = hierarchicalParts[2].substring(LEDGER_NODE_PREFIX.length());
        return StringUtils.stringToHierarchicalLedgerId(hierarchicalParts);
    }

    public static long stringToHierarchicalLedgerId(String ... levelNodes) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            for (String node : levelNodes) {
                sb.append(node);
            }
            return Long.parseLong(sb.toString());
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }
}

