/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.util;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bk_v4_2_0.bookkeeper.util.MathUtils;
import org.apache.bk_v4_2_0.bookkeeper.util.SafeRunnable;

public class OrderedSafeExecutor {
    ExecutorService[] threads;
    Random rand = new Random();

    public OrderedSafeExecutor(int numThreads) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException();
        }
        this.threads = new ExecutorService[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.threads[i] = Executors.newSingleThreadExecutor();
        }
    }

    ExecutorService chooseThread() {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        return this.threads[this.rand.nextInt(this.threads.length)];
    }

    ExecutorService chooseThread(Object orderingKey) {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        return this.threads[MathUtils.signSafeMod(orderingKey.hashCode(), this.threads.length)];
    }

    public void submit(SafeRunnable r) {
        this.chooseThread().submit(r);
    }

    public void submitOrdered(Object orderingKey, SafeRunnable r) {
        this.chooseThread(orderingKey).submit(r);
    }

    public void shutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].shutdown();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean ret = true;
        for (int i = 0; i < this.threads.length; ++i) {
            ret = ret && this.threads[i].awaitTermination(timeout, unit);
        }
        return ret;
    }

    public static abstract class OrderedSafeGenericCallback<T>
    implements BookkeeperInternalCallbacks.GenericCallback<T> {
        private final OrderedSafeExecutor executor;
        private final Object orderingKey;

        public OrderedSafeGenericCallback(OrderedSafeExecutor executor, Object orderingKey) {
            this.executor = executor;
            this.orderingKey = orderingKey;
        }

        @Override
        public final void operationComplete(final int rc, final T result) {
            this.executor.submitOrdered(this.orderingKey, new SafeRunnable(){

                @Override
                public void safeRun() {
                    OrderedSafeGenericCallback.this.safeOperationComplete(rc, result);
                }
            });
        }

        public abstract void safeOperationComplete(int var1, T var2);
    }
}

