/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.tools;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.client.BKException;
import org.apache.bk_v4_2_0.bookkeeper.client.BookKeeperAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperTools {
    private static Logger LOG = LoggerFactory.getLogger(BookKeeperTools.class);

    public static void main(String[] args) throws InterruptedException, IOException, KeeperException, BKException {
        if (args.length < 2) {
            System.err.println("USAGE: BookKeeperTools zkServers bookieSrc [bookieDest]");
            return;
        }
        String zkServers = args[0];
        String[] bookieSrcString = args[1].split(":");
        if (bookieSrcString.length < 2) {
            System.err.println("BookieSrc inputted has invalid name format (host:port expected): " + args[1]);
            return;
        }
        InetSocketAddress bookieSrc = new InetSocketAddress(bookieSrcString[0], Integer.parseInt(bookieSrcString[1]));
        InetSocketAddress bookieDest = null;
        if (args.length < 3) {
            String[] bookieDestString = args[2].split(":");
            if (bookieDestString.length < 2) {
                System.err.println("BookieDest inputted has invalid name format (host:port expected): " + args[2]);
                return;
            }
            bookieDest = new InetSocketAddress(bookieDestString[0], Integer.parseInt(bookieDestString[1]));
        }
        BookKeeperAdmin bkTools = new BookKeeperAdmin(zkServers);
        bkTools.recoverBookieData(bookieSrc, bookieDest);
        bkTools.close();
    }
}

