/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.server.quorum;

import java.io.IOException;
import java.util.HashMap;
import org.apache.bk_v4_2_0.bookkeeper.jmx.MBeanRegistry;
import org.apache.bk_v4_2_0.bookkeeper.server.DataTreeBean;
import org.apache.bk_v4_2_0.bookkeeper.server.ServerCnxn;
import org.apache.bk_v4_2_0.bookkeeper.server.ZKDatabase;
import org.apache.bk_v4_2_0.bookkeeper.server.ZooKeeperServer;
import org.apache.bk_v4_2_0.bookkeeper.server.ZooKeeperServerBean;
import org.apache.bk_v4_2_0.bookkeeper.server.persistence.FileTxnSnapLog;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.Learner;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.LearnerSessionTracker;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.LocalPeerBean;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.QuorumPeer;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.QuorumZooKeeperServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LearnerZooKeeperServer
extends QuorumZooKeeperServer {
    public LearnerZooKeeperServer(FileTxnSnapLog logFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb, QuorumPeer self) throws IOException {
        super(logFactory, tickTime, minSessionTimeout, maxSessionTimeout, treeBuilder, zkDb, self);
    }

    public abstract Learner getLearner();

    protected HashMap<Long, Integer> getTouchSnapshot() {
        if (this.sessionTracker != null) {
            return ((LearnerSessionTracker)this.sessionTracker).snapshot();
        }
        return new HashMap<Long, Integer>();
    }

    @Override
    public long getServerId() {
        return this.self.getId();
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new LearnerSessionTracker(this, this.getZKDatabase().getSessionWithTimeOuts(), this.self.getId());
    }

    @Override
    protected void startSessionTracker() {
    }

    @Override
    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException {
        this.getLearner().validateSession(cnxn, sessionId, sessionTimeout);
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(ZooKeeperServerBean serverBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", (Throwable)e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = serverBean;
            MBeanRegistry.getInstance().register(serverBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Learner peer) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxServerBean = null;
    }
}

