/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.server.quorum;

import org.apache.bk_v4_2_0.bookkeeper.server.Request;
import org.apache.bk_v4_2_0.bookkeeper.server.RequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.Leader;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.QuorumPeer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AckRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AckRequestProcessor.class);
    Leader leader;

    AckRequestProcessor(Leader leader) {
        this.leader = leader;
    }

    public void processRequest(Request request) {
        QuorumPeer self = this.leader.self;
        if (self != null) {
            this.leader.processAck(self.getId(), request.zxid, null);
        } else {
            LOG.error("Null QuorumPeer");
        }
    }

    public void shutdown() {
    }
}

