/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.server.auth;

import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.server.ServerCnxn;
import org.apache.bk_v4_2_0.bookkeeper.server.auth.AuthenticationProvider;
import org.apache.bk_v4_2_0.bookkeeper.server.auth.KerberosName;

public class SASLAuthenticationProvider
implements AuthenticationProvider {
    public String getScheme() {
        return "sasl";
    }

    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        return KeeperException.Code.AUTHFAILED;
    }

    public boolean matches(String id, String aclExpr) {
        if (System.getProperty("zookeeper.superUser") != null) {
            return id.equals(System.getProperty("zookeeper.superUser")) || id.equals(aclExpr);
        }
        return id.equals("super") || id.equals(aclExpr);
    }

    public boolean isAuthenticated() {
        return true;
    }

    public boolean isValid(String id) {
        try {
            new KerberosName(id);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

