/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.bk_v4_2_0.bookkeeper.server.persistence.FileTxnSnapLog;
import org.apache.bk_v4_2_0.bookkeeper.server.persistence.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeTxnLog {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeTxnLog.class);

    static void printUsage() {
        System.out.println("PurgeTxnLog dataLogDir [snapDir] -n count");
        System.out.println("\tdataLogDir -- path to the txn log directory");
        System.out.println("\tsnapDir -- path to the snapshot directory");
        System.out.println("\tcount -- the number of old snaps/logs you want to keep");
        System.exit(1);
    }

    public static void purge(File dataDir, File snapDir, int num) throws IOException {
        if (num < 3) {
            throw new IllegalArgumentException("count should be greater than 3");
        }
        FileTxnSnapLog txnLog = new FileTxnSnapLog(dataDir, snapDir);
        HashSet<File> exc = new HashSet<File>();
        List<File> snaps = txnLog.findNRecentSnapshots(num);
        if (snaps.size() == 0) {
            return;
        }
        File snapShot = snaps.get(snaps.size() - 1);
        for (File f : snaps) {
            exc.add(f);
        }
        long zxid = Util.getZxidFromName(snapShot.getName(), "snapshot");
        exc.addAll(Arrays.asList(txnLog.getSnapshotLogs(zxid)));
        HashSet<File> exclude = exc;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyFileFilter
        implements FileFilter {
            private final String prefix;
            final /* synthetic */ Set val$exclude;

            MyFileFilter(String string) {
                this.val$exclude = string;
                this.prefix = prefix;
            }

            @Override
            public boolean accept(File f) {
                return f.getName().startsWith(this.prefix) && !this.val$exclude.contains(f);
            }
        }
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(txnLog.getDataDir().listFiles(new MyFileFilter("log.", exclude))));
        files.addAll(Arrays.asList(txnLog.getSnapDir().listFiles(new MyFileFilter("snapshot.", exclude))));
        for (File f : files) {
            System.out.println("Removing file: " + DateFormat.getDateTimeInstance().format(f.lastModified()) + "\t" + f.getPath());
            if (f.delete()) continue;
            System.err.println("Failed to remove " + f.getPath());
        }
    }

    public static void main(String[] args) throws IOException {
        File dataDir;
        if (args.length < 3 || args.length > 4) {
            PurgeTxnLog.printUsage();
        }
        int i = 0;
        File snapDir = dataDir = new File(args[0]);
        if (args.length == 4) {
            snapDir = new File(args[++i]);
        }
        ++i;
        int num = Integer.parseInt(args[++i]);
        PurgeTxnLog.purge(dataDir, snapDir, num);
    }
}

