/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.replication;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.WatchedEvent;
import org.apache.bk_v4_2_0.bookkeeper.Watcher;
import org.apache.bk_v4_2_0.bookkeeper.ZooKeeper;
import org.apache.bk_v4_2_0.bookkeeper.bookie.Bookie;
import org.apache.bk_v4_2_0.bookkeeper.conf.ServerConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.replication.AuditorElector;
import org.apache.bk_v4_2_0.bookkeeper.replication.ReplicationException;
import org.apache.bk_v4_2_0.bookkeeper.replication.ReplicationWorker;
import org.apache.bk_v4_2_0.bookkeeper.util.StringUtils;
import org.apache.bk_v4_2_0.bookkeeper.util.ZkUtils;
import org.apache.bk_v4_2_0.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.bk_v4_2_0.commons.cli.BasicParser;
import org.apache.bk_v4_2_0.commons.cli.CommandLine;
import org.apache.bk_v4_2_0.commons.cli.HelpFormatter;
import org.apache.bk_v4_2_0.commons.cli.Options;
import org.apache.bk_v4_2_0.commons.cli.ParseException;
import org.apache.bk_v4_2_0.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoRecoveryMain {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRecoveryMain.class);
    private ServerConfiguration conf;
    private ZooKeeper zk;
    AuditorElector auditorElector;
    ReplicationWorker replicationWorker;
    private AutoRecoveryDeathWatcher deathWatcher;
    private int exitCode;
    private volatile boolean shuttingDown = false;
    private volatile boolean running = false;
    private static final Options opts = new Options();

    public AutoRecoveryMain(ServerConfiguration conf) throws IOException, InterruptedException, KeeperException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException {
        this.conf = conf;
        ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(conf.getZkTimeout()){

            @Override
            public void process(WatchedEvent event) {
                if (event.getState().equals((Object)Watcher.Event.KeeperState.Expired)) {
                    LOG.error("ZK client connection to the ZK server has expired!");
                    AutoRecoveryMain.this.shutdown(3);
                } else {
                    super.process(event);
                }
            }
        };
        this.zk = ZkUtils.createConnectedZookeeperClient(conf.getZkServers(), w);
        this.auditorElector = new AuditorElector(StringUtils.addrToString(Bookie.getBookieAddress(conf)), conf, this.zk);
        this.replicationWorker = new ReplicationWorker(this.zk, conf, Bookie.getBookieAddress(conf));
        this.deathWatcher = new AutoRecoveryDeathWatcher(this);
    }

    public void start() throws ReplicationException.UnavailableException {
        this.auditorElector.start();
        this.replicationWorker.start();
        this.deathWatcher.start();
        this.running = true;
    }

    public void join() throws InterruptedException {
        this.deathWatcher.join();
    }

    public void shutdown() {
        this.shutdown(0);
    }

    private void shutdown(int exitCode) {
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        this.running = false;
        this.exitCode = exitCode;
        try {
            this.deathWatcher.interrupt();
            this.deathWatcher.join();
            this.auditorElector.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted shutting down auto recovery", (Throwable)e);
        }
        this.replicationWorker.shutdown();
        try {
            this.zk.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted shutting down auto recovery", (Throwable)e);
        }
    }

    private int getExitCode() {
        return this.exitCode;
    }

    public boolean isAutoRecoveryRunning() {
        return this.running;
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("AutoRecoveryMain [options]\n", opts);
    }

    private static void loadConfFile(ServerConfiguration conf, String confFile) throws IllegalArgumentException {
        try {
            conf.loadConf(new File(confFile).toURI().toURL());
        }
        catch (MalformedURLException e) {
            LOG.error("Could not open configuration file: " + confFile, (Throwable)e);
            throw new IllegalArgumentException();
        }
        catch (ConfigurationException e) {
            LOG.error("Malformed configuration file: " + confFile, (Throwable)e);
            throw new IllegalArgumentException();
        }
        LOG.info("Using configuration file " + confFile);
    }

    private static ServerConfiguration parseArgs(String[] args) throws IllegalArgumentException {
        try {
            BasicParser parser = new BasicParser();
            CommandLine cmdLine = parser.parse(opts, args);
            if (cmdLine.hasOption('h')) {
                throw new IllegalArgumentException();
            }
            ServerConfiguration conf = new ServerConfiguration();
            String[] leftArgs = cmdLine.getArgs();
            if (cmdLine.hasOption('c')) {
                if (null != leftArgs && leftArgs.length > 0) {
                    throw new IllegalArgumentException();
                }
                String confFile = cmdLine.getOptionValue("c");
                AutoRecoveryMain.loadConfFile(conf, confFile);
            }
            if (null != leftArgs && leftArgs.length > 0) {
                throw new IllegalArgumentException();
            }
            return conf;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void main(String[] args) {
        ServerConfiguration conf = null;
        try {
            conf = AutoRecoveryMain.parseArgs(args);
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Error parsing command line arguments : ", (Throwable)iae);
            System.err.println(iae.getMessage());
            AutoRecoveryMain.printUsage();
            System.exit(1);
        }
        try {
            final AutoRecoveryMain autoRecoveryMain = new AutoRecoveryMain(conf);
            autoRecoveryMain.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    autoRecoveryMain.shutdown();
                    LOG.info("Shutdown AutoRecoveryMain successfully");
                }
            });
            LOG.info("Register shutdown hook successfully");
            autoRecoveryMain.join();
            System.exit(autoRecoveryMain.getExitCode());
        }
        catch (Exception e) {
            LOG.error("Exception running AutoRecoveryMain : ", (Throwable)e);
            System.exit(2);
        }
    }

    static {
        opts.addOption("c", "conf", true, "Bookie server configuration");
        opts.addOption("h", "help", false, "Print help message");
    }

    private static class AutoRecoveryDeathWatcher
    extends Thread {
        private int watchInterval;
        private AutoRecoveryMain autoRecoveryMain;

        public AutoRecoveryDeathWatcher(AutoRecoveryMain autoRecoveryMain) {
            super("AutoRecoveryDeathWatcher-" + autoRecoveryMain.conf.getBookiePort());
            this.autoRecoveryMain = autoRecoveryMain;
            this.watchInterval = autoRecoveryMain.conf.getDeathWatchInterval();
        }

        @Override
        public void run() {
            block3: {
                do {
                    try {
                        Thread.sleep(this.watchInterval);
                    }
                    catch (InterruptedException ie) {
                        break block3;
                    }
                } while (this.autoRecoveryMain.auditorElector.isRunning() && this.autoRecoveryMain.replicationWorker.isRunning());
                this.autoRecoveryMain.shutdown();
            }
        }
    }
}

