/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.proto;

import java.net.UnknownHostException;
import org.apache.bk_v4_2_0.bookkeeper.bookie.Bookie;
import org.apache.bk_v4_2_0.bookkeeper.conf.ServerConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.jmx.BKMBeanInfo;
import org.apache.bk_v4_2_0.bookkeeper.proto.BKStats;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookieServer;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookieServerMXBean;
import org.apache.bk_v4_2_0.bookkeeper.proto.ServerStats;
import org.apache.bk_v4_2_0.bookkeeper.util.StringUtils;

public class BookieServerBean
implements BookieServerMXBean,
BKMBeanInfo {
    protected final BookieServer bks;
    protected final ServerConfiguration conf;
    private final String name;

    public BookieServerBean(ServerConfiguration conf, BookieServer bks) {
        this.conf = conf;
        this.bks = bks;
        this.name = "BookieServer_" + conf.getBookiePort();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long getNumPacketsReceived() {
        return ServerStats.getInstance().getPacketsReceived();
    }

    @Override
    public long getNumPacketsSent() {
        return ServerStats.getInstance().getPacketsSent();
    }

    @Override
    public BKStats.OpStatData getAddStats() {
        return this.bks.bkStats.getOpStats(0).toOpStatData();
    }

    @Override
    public BKStats.OpStatData getReadStats() {
        return this.bks.bkStats.getOpStats(1).toOpStatData();
    }

    @Override
    public String getServerState() {
        return this.bks.nioServerFactory.stats.getServerState();
    }

    @Override
    public String getServerPort() {
        try {
            return StringUtils.addrToString(Bookie.getBookieAddress(this.conf));
        }
        catch (UnknownHostException e) {
            return "localhost:" + this.conf.getBookiePort();
        }
    }
}

