/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.meta;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import org.apache.bk_v4_2_0.bookkeeper.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerMetadata;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bk_v4_2_0.bookkeeper.versioning.Version;

public interface LedgerManager
extends Closeable {
    public void createLedger(LedgerMetadata var1, BookkeeperInternalCallbacks.GenericCallback<Long> var2);

    public void removeLedgerMetadata(long var1, Version var3, BookkeeperInternalCallbacks.GenericCallback<Void> var4);

    public void readLedgerMetadata(long var1, BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> var3);

    public void writeLedgerMetadata(long var1, LedgerMetadata var3, BookkeeperInternalCallbacks.GenericCallback<Void> var4);

    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> var1, AsyncCallback.VoidCallback var2, Object var3, int var4, int var5);

    public LedgerRangeIterator getLedgerRanges();

    public static interface LedgerRangeIterator {
        public boolean hasNext() throws IOException;

        public LedgerRange next() throws IOException;
    }

    public static class LedgerRange {
        private final long start;
        private final long end;
        public static final long NOLIMIT = -1L;
        private Set<Long> ledgers;

        public LedgerRange(Set<Long> ledgers) {
            this(ledgers, -1L, -1L);
        }

        public LedgerRange(Set<Long> ledgers, long start) {
            this(ledgers, start, -1L);
        }

        public LedgerRange(Set<Long> ledgers, long start, long end) {
            this.ledgers = ledgers;
            this.start = start;
            this.end = end;
        }

        public Long start() {
            return this.start;
        }

        public Long end() {
            return this.end;
        }

        public Set<Long> getLedgers() {
            return this.ledgers;
        }
    }
}

