/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.meta;

import java.io.IOException;
import java.util.List;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.ZKUtil;
import org.apache.bk_v4_2_0.bookkeeper.ZooKeeper;
import org.apache.bk_v4_2_0.bookkeeper.conf.AbstractConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.meta.FlatLedgerManager;
import org.apache.bk_v4_2_0.bookkeeper.meta.LedgerManager;
import org.apache.bk_v4_2_0.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bk_v4_2_0.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bk_v4_2_0.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bk_v4_2_0.bookkeeper.replication.ReplicationException;

class FlatLedgerManagerFactory
extends LedgerManagerFactory {
    public static final String NAME = "flat";
    public static final int CUR_VERSION = 1;
    AbstractConfiguration conf;
    ZooKeeper zk;

    FlatLedgerManagerFactory() {
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public LedgerManagerFactory initialize(AbstractConfiguration conf, ZooKeeper zk, int factoryVersion) throws IOException {
        if (1 != factoryVersion) {
            throw new IOException("Incompatible layout version found : " + factoryVersion);
        }
        this.conf = conf;
        this.zk = zk;
        return this;
    }

    @Override
    public void uninitialize() throws IOException {
    }

    @Override
    public LedgerManager newLedgerManager() {
        return new FlatLedgerManager(this.conf, this.zk);
    }

    @Override
    public LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws KeeperException, InterruptedException, ReplicationException.CompatibilityException {
        return new ZkLedgerUnderreplicationManager(this.conf, this.zk);
    }

    @Override
    public void format(AbstractConfiguration conf, ZooKeeper zk) throws InterruptedException, KeeperException, IOException {
        FlatLedgerManager ledgerManager = (FlatLedgerManager)this.newLedgerManager();
        String ledgersRootPath = conf.getZkLedgersRootPath();
        List<String> children = zk.getChildren(ledgersRootPath, false);
        for (String child : children) {
            if (ledgerManager.isSpecialZnode(child)) continue;
            ZKUtil.deleteRecursive(zk, ledgersRootPath + "/" + child);
        }
        super.format(conf, zk);
    }
}

