/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.meta;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.bk_v4_2_0.bookkeeper.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.CreateMode;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.ZooDefs;
import org.apache.bk_v4_2_0.bookkeeper.ZooKeeper;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerMetadata;
import org.apache.bk_v4_2_0.bookkeeper.conf.AbstractConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.bk_v4_2_0.bookkeeper.meta.LedgerManager;
import org.apache.bk_v4_2_0.bookkeeper.meta.ZkVersion;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bk_v4_2_0.bookkeeper.util.StringUtils;
import org.apache.bk_v4_2_0.bookkeeper.util.ZkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlatLedgerManager
extends AbstractZkLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(FlatLedgerManager.class);
    private final String ledgerPrefix;

    public FlatLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        super(conf, zk);
        this.ledgerPrefix = this.ledgerRootPath + "/" + "L";
    }

    @Override
    public void createLedger(final LedgerMetadata metadata, final BookkeeperInternalCallbacks.GenericCallback<Long> cb) {
        AsyncCallback.StringCallback scb = new AsyncCallback.StringCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, String name) {
                if (KeeperException.Code.OK.intValue() != rc) {
                    LOG.error("Could not create node for ledger", (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                    cb.operationComplete(rc, null);
                } else {
                    metadata.setVersion(new ZkVersion(0));
                    try {
                        long ledgerId = FlatLedgerManager.this.getLedgerId(name);
                        cb.operationComplete(rc, ledgerId);
                    }
                    catch (IOException ie) {
                        LOG.error("Could not extract ledger-id from path:" + name, (Throwable)ie);
                        cb.operationComplete(-9, null);
                    }
                }
            }
        };
        ZkUtils.createFullPathOptimistic(this.zk, this.ledgerPrefix, metadata.serialize(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, scb, null);
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ledgerPrefix).append(StringUtils.getZKStringId(ledgerId));
        return sb.toString();
    }

    @Override
    public long getLedgerId(String nodeName) throws IOException {
        long ledgerId;
        try {
            String[] parts = nodeName.split(this.ledgerPrefix);
            ledgerId = Long.parseLong(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return ledgerId;
    }

    @Override
    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object ctx, int successRc, int failureRc) {
        this.asyncProcessLedgersInSingleNode(this.ledgerRootPath, processor, finalCb, ctx, successRc, failureRc);
    }

    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges() {
        return new LedgerManager.LedgerRangeIterator(){
            boolean hasMoreElement = true;

            @Override
            public boolean hasNext() {
                return this.hasMoreElement;
            }

            @Override
            public LedgerManager.LedgerRange next() throws IOException {
                Set<Long> zkActiveLedgers;
                if (!this.hasMoreElement) {
                    throw new NoSuchElementException();
                }
                this.hasMoreElement = false;
                try {
                    zkActiveLedgers = FlatLedgerManager.this.ledgerListToSet(ZkUtils.getChildrenInSingleNode(FlatLedgerManager.this.zk, FlatLedgerManager.this.ledgerRootPath), FlatLedgerManager.this.ledgerRootPath);
                }
                catch (InterruptedException e) {
                    throw new IOException("Error when get child nodes from zk", e);
                }
                return new LedgerManager.LedgerRange(zkActiveLedgers);
            }
        };
    }
}

