/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.meta;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.bk_v4_2_0.bookkeeper.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.ZooKeeper;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerMetadata;
import org.apache.bk_v4_2_0.bookkeeper.conf.AbstractConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.data.Stat;
import org.apache.bk_v4_2_0.bookkeeper.meta.LedgerManager;
import org.apache.bk_v4_2_0.bookkeeper.meta.ZkVersion;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bk_v4_2_0.bookkeeper.util.ZkUtils;
import org.apache.bk_v4_2_0.bookkeeper.versioning.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractZkLedgerManager
implements LedgerManager {
    static Logger LOG = LoggerFactory.getLogger(AbstractZkLedgerManager.class);
    protected final AbstractConfiguration conf;
    protected final ZooKeeper zk;
    protected final String ledgerRootPath;

    protected AbstractZkLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        this.conf = conf;
        this.zk = zk;
        this.ledgerRootPath = conf.getZkLedgersRootPath();
    }

    protected abstract String getLedgerPath(long var1);

    protected abstract long getLedgerId(String var1) throws IOException;

    @Override
    public void removeLedgerMetadata(final long ledgerId, Version version, final BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        int znodeVersion = -1;
        if (Version.NEW == version) {
            LOG.error("Request to delete ledger {} metadata with version set to the initial one", (Object)ledgerId);
            cb.operationComplete(-17, null);
            return;
        }
        if (Version.ANY != version) {
            if (!(version instanceof ZkVersion)) {
                LOG.info("Not an instance of ZKVersion: {}", (Object)ledgerId);
                cb.operationComplete(-17, null);
                return;
            }
            znodeVersion = ((ZkVersion)version).getZnodeVersion();
        }
        this.zk.delete(this.getLedgerPath(ledgerId), znodeVersion, new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                int bkRc;
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    LOG.warn("Ledger node does not exist in ZooKeeper: ledgerId={}", (Object)ledgerId);
                    bkRc = -7;
                } else {
                    bkRc = rc == KeeperException.Code.OK.intValue() ? 0 : -9;
                }
                cb.operationComplete(bkRc, null);
            }
        }, null);
    }

    @Override
    public void readLedgerMetadata(final long ledgerId, final BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> readCb) {
        this.zk.getData(this.getLedgerPath(ledgerId), false, new AsyncCallback.DataCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                LedgerMetadata metadata;
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No such ledger: " + ledgerId, (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                    }
                    readCb.operationComplete(-7, null);
                    return;
                }
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Could not read metadata for ledger: " + ledgerId, (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                    readCb.operationComplete(-9, null);
                    return;
                }
                try {
                    metadata = LedgerMetadata.parseConfig(data, new ZkVersion(stat.getVersion()));
                }
                catch (IOException e) {
                    LOG.error("Could not parse ledger metadata for ledger: " + ledgerId, (Throwable)e);
                    readCb.operationComplete(-9, null);
                    return;
                }
                readCb.operationComplete(0, metadata);
            }
        }, null);
    }

    @Override
    public void writeLedgerMetadata(long ledgerId, final LedgerMetadata metadata, final BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        Version v = metadata.getVersion();
        if (Version.NEW == v || !(v instanceof ZkVersion)) {
            cb.operationComplete(-17, null);
            return;
        }
        final ZkVersion zv = (ZkVersion)v;
        this.zk.setData(this.getLedgerPath(ledgerId), metadata.serialize(), zv.getZnodeVersion(), new AsyncCallback.StatCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, Stat stat) {
                if (-103 == rc) {
                    cb.operationComplete(-17, null);
                } else if (KeeperException.Code.OK.intValue() == rc) {
                    metadata.setVersion(zv.setZnodeVersion(stat.getVersion()));
                    cb.operationComplete(0, null);
                } else {
                    LOG.warn("Conditional update ledger metadata failed: ", (Object)KeeperException.Code.get(rc));
                    cb.operationComplete(-9, null);
                }
            }
        }, null);
    }

    protected void asyncProcessLedgersInSingleNode(final String path, final BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object ctx, final int successRc, final int failureRc) {
        ZkUtils.getChildrenInSingleNode(this.zk, path, new BookkeeperInternalCallbacks.GenericCallback<List<String>>(){

            @Override
            public void operationComplete(int rc, List<String> ledgerNodes) {
                if (KeeperException.Code.OK.intValue() != rc) {
                    finalCb.processResult(failureRc, null, ctx);
                    return;
                }
                Set<Long> zkActiveLedgers = AbstractZkLedgerManager.this.ledgerListToSet(ledgerNodes, path);
                LOG.debug("Processing ledgers: {}", zkActiveLedgers);
                if (zkActiveLedgers.size() == 0) {
                    finalCb.processResult(successRc, null, ctx);
                    return;
                }
                BookkeeperInternalCallbacks.MultiCallback mcb = new BookkeeperInternalCallbacks.MultiCallback(zkActiveLedgers.size(), finalCb, ctx, successRc, failureRc);
                for (Long ledger : zkActiveLedgers) {
                    processor.process(ledger, mcb);
                }
            }
        });
    }

    protected boolean isSpecialZnode(String znode) {
        return "available".equals(znode) || "cookies".equals(znode) || "LAYOUT".equals(znode) || "INSTANCEID".equals(znode) || "underreplication".equals(znode);
    }

    protected Set<Long> ledgerListToSet(List<String> ledgerNodes, String path) {
        HashSet<Long> zkActiveLedgers = new HashSet<Long>(ledgerNodes.size(), 1.0f);
        for (String ledgerNode : ledgerNodes) {
            if (this.isSpecialZnode(ledgerNode)) continue;
            try {
                zkActiveLedgers.add(this.getLedgerId(path + "/" + ledgerNode));
            }
            catch (IOException e) {
                LOG.warn("Error extracting ledgerId from ZK ledger node: " + ledgerNode);
            }
        }
        return zkActiveLedgers;
    }

    @Override
    public void close() {
    }
}

