/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import org.apache.bk_v4_2_0.bookkeeper.client.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.client.BKException;
import org.apache.bk_v4_2_0.bookkeeper.client.BookKeeper;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerHandle;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerMetadata;

class ReadOnlyLedgerHandle
extends LedgerHandle {
    ReadOnlyLedgerHandle(BookKeeper bk, long ledgerId, LedgerMetadata metadata, BookKeeper.DigestType digestType, byte[] password) throws GeneralSecurityException, NumberFormatException {
        super(bk, ledgerId, metadata, digestType, password);
    }

    @Override
    public void close() throws InterruptedException, BKException {
    }

    @Override
    public void asyncClose(AsyncCallback.CloseCallback cb, Object ctx) {
        cb.closeComplete(0, this, ctx);
    }

    @Override
    public long addEntry(byte[] data) throws InterruptedException, BKException {
        return this.addEntry(data, 0, data.length);
    }

    @Override
    public long addEntry(byte[] data, int offset, int length) throws InterruptedException, BKException {
        LOG.error("Tried to add entry on a Read-Only ledger handle, ledgerid=" + this.ledgerId);
        throw BKException.create(-100);
    }

    @Override
    public void asyncAddEntry(byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(data, 0, data.length, cb, ctx);
    }

    @Override
    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        LOG.error("Tried to add entry on a Read-Only ledger handle, ledgerid=" + this.ledgerId);
        cb.addComplete(-100, this, -1L, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleBookieFailure(InetSocketAddress addr, int bookieIndex) {
        this.blockAddCompletions.incrementAndGet();
        LedgerMetadata ledgerMetadata = this.metadata;
        synchronized (ledgerMetadata) {
            try {
                if (!this.metadata.currentEnsemble.get(bookieIndex).equals(addr)) {
                    LOG.warn("Write did not succeed to {}, bookieIndex {}, but we have already fixed it.", (Object)addr, (Object)bookieIndex);
                    this.blockAddCompletions.decrementAndGet();
                    return;
                }
                this.replaceBookieInMetadata(addr, bookieIndex);
                this.blockAddCompletions.decrementAndGet();
                this.unsetSuccessAndSendWriteRequest(bookieIndex);
            }
            catch (BKException.BKNotEnoughBookiesException e) {
                LOG.error("Could not get additional bookie to remake ensemble, closing ledger: " + this.ledgerId);
                this.handleUnrecoverableErrorDuringAdd(e.getCode());
                return;
            }
        }
    }
}

