/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import org.apache.bk_v4_2_0.bookkeeper.client.BKException;
import org.apache.bk_v4_2_0.bookkeeper.client.DigestManager;
import org.apache.bk_v4_2_0.bookkeeper.client.DistributionSchedule;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerHandle;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadLastConfirmedOp
implements BookkeeperInternalCallbacks.ReadEntryCallback {
    static final Logger LOG = LoggerFactory.getLogger(ReadLastConfirmedOp.class);
    LedgerHandle lh;
    int numResponsesPending;
    DigestManager.RecoveryData maxRecoveredData;
    volatile boolean completed = false;
    LastConfirmedDataCallback cb;
    final DistributionSchedule.QuorumCoverageSet coverageSet;

    public ReadLastConfirmedOp(LedgerHandle lh, LastConfirmedDataCallback cb) {
        this.cb = cb;
        this.maxRecoveredData = new DigestManager.RecoveryData(-1L, 0L);
        this.lh = lh;
        this.numResponsesPending = lh.metadata.getEnsembleSize();
        this.coverageSet = lh.distributionSchedule.getCoverageSet();
    }

    public void initiate() {
        for (int i = 0; i < this.lh.metadata.currentEnsemble.size(); ++i) {
            this.lh.bk.bookieClient.readEntry(this.lh.metadata.currentEnsemble.get(i), this.lh.ledgerId, -1L, this, i);
        }
    }

    public void initiateWithFencing() {
        for (int i = 0; i < this.lh.metadata.currentEnsemble.size(); ++i) {
            this.lh.bk.bookieClient.readEntryAndFenceLedger(this.lh.metadata.currentEnsemble.get(i), this.lh.ledgerId, this.lh.ledgerKey, -1L, this, i);
        }
    }

    @Override
    public synchronized void readEntryComplete(int rc, long ledgerId, long entryId, ChannelBuffer buffer, Object ctx) {
        int bookieIndex = (Integer)ctx;
        --this.numResponsesPending;
        boolean heardValidResponse = false;
        if (rc == 0) {
            try {
                DigestManager.RecoveryData recoveryData = this.lh.macManager.verifyDigestAndReturnLastConfirmed(buffer);
                if (recoveryData.lastAddConfirmed > this.maxRecoveredData.lastAddConfirmed) {
                    this.maxRecoveredData = recoveryData;
                }
                heardValidResponse = true;
            }
            catch (BKException.BKDigestMatchException e) {
                LOG.error("Mac mismatch for ledger: " + ledgerId + ", entry: " + entryId + " while reading last entry from bookie: " + this.lh.metadata.currentEnsemble.get(bookieIndex));
            }
        }
        if (rc == -7 || rc == -13) {
            heardValidResponse = true;
        }
        if (rc == -102 && !this.completed) {
            this.cb.readLastConfirmedDataComplete(rc, this.maxRecoveredData);
            this.completed = true;
        }
        if (heardValidResponse && this.coverageSet.addBookieAndCheckCovered(bookieIndex) && !this.completed) {
            this.completed = true;
            LOG.debug("Read Complete with enough validResponses for ledger: {}, entry: {}", (Object)ledgerId, (Object)entryId);
            this.cb.readLastConfirmedDataComplete(0, this.maxRecoveredData);
            return;
        }
        if (this.numResponsesPending == 0 && !this.completed) {
            LOG.error("While readLastConfirmed ledger: " + ledgerId + " did not hear success responses from all quorums");
            this.cb.readLastConfirmedDataComplete(-10, this.maxRecoveredData);
        }
    }

    static interface LastConfirmedDataCallback {
        public void readLastConfirmedDataComplete(int var1, DigestManager.RecoveryData var2);
    }
}

