/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.bk_v4_2_0.bookkeeper.client.DigestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MacDigestManager
extends DigestManager {
    static final Logger LOG = LoggerFactory.getLogger(MacDigestManager.class);
    public static String DIGEST_ALGORITHM = "SHA-1";
    public static String KEY_ALGORITHM = "HmacSHA1";
    final byte[] passwd;
    private final ThreadLocal<Mac> mac = new ThreadLocal<Mac>(){

        @Override
        protected Mac initialValue() {
            try {
                byte[] macKey = MacDigestManager.genDigest("mac", MacDigestManager.this.passwd);
                SecretKeySpec keySpec = new SecretKeySpec(macKey, KEY_ALGORITHM);
                Mac mac = Mac.getInstance(KEY_ALGORITHM);
                mac.init(keySpec);
                return mac;
            }
            catch (GeneralSecurityException gse) {
                LOG.error("Couldn't not get mac instance", (Throwable)gse);
                return null;
            }
        }
    };

    public MacDigestManager(long ledgerId, byte[] passwd) throws GeneralSecurityException {
        super(ledgerId);
        this.passwd = passwd;
    }

    static byte[] genDigest(String pad, byte[] passwd) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        digest.update(pad.getBytes());
        digest.update(passwd);
        return digest.digest();
    }

    @Override
    int getMacCodeLength() {
        return 20;
    }

    @Override
    byte[] getValueAndReset() {
        return this.mac.get().doFinal();
    }

    @Override
    void update(byte[] data, int offset, int length) {
        this.mac.get().update(data, offset, length);
    }
}

