/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.bk_v4_2_0.bookkeeper.client.BookKeeper;
import org.apache.bk_v4_2_0.bookkeeper.proto.DataFormats;
import org.apache.bk_v4_2_0.bookkeeper.util.StringUtils;
import org.apache.bk_v4_2_0.bookkeeper.versioning.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerMetadata {
    static final Logger LOG = LoggerFactory.getLogger(LedgerMetadata.class);
    private static final String closed = "CLOSED";
    private static final String lSplitter = "\n";
    private static final String tSplitter = "\t";
    private static final int NOTCLOSED = -101;
    private static final int IN_RECOVERY = -102;
    public static final int LOWEST_COMPAT_METADATA_FORMAT_VERSION = 0;
    public static final int CURRENT_METADATA_FORMAT_VERSION = 2;
    public static final String VERSION_KEY = "BookieMetadataFormatVersion";
    private int metadataFormatVersion = 0;
    private int ensembleSize;
    private int writeQuorumSize;
    private int ackQuorumSize;
    private long length;
    private long lastEntryId;
    private DataFormats.LedgerMetadataFormat.State state;
    private SortedMap<Long, ArrayList<InetSocketAddress>> ensembles = new TreeMap<Long, ArrayList<InetSocketAddress>>();
    ArrayList<InetSocketAddress> currentEnsemble;
    volatile Version version = Version.NEW;
    private boolean hasPassword = false;
    private DataFormats.LedgerMetadataFormat.DigestType digestType;
    private byte[] password;

    public LedgerMetadata(int ensembleSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] password) {
        this.ensembleSize = ensembleSize;
        this.writeQuorumSize = writeQuorumSize;
        this.ackQuorumSize = ackQuorumSize;
        this.length = 0L;
        this.state = DataFormats.LedgerMetadataFormat.State.OPEN;
        this.lastEntryId = -1L;
        this.metadataFormatVersion = 2;
        this.digestType = digestType.equals((Object)BookKeeper.DigestType.MAC) ? DataFormats.LedgerMetadataFormat.DigestType.HMAC : DataFormats.LedgerMetadataFormat.DigestType.CRC32;
        this.password = Arrays.copyOf(password, password.length);
        this.hasPassword = true;
    }

    private LedgerMetadata() {
        this(0, 0, 0, BookKeeper.DigestType.MAC, new byte[0]);
        this.hasPassword = false;
    }

    public SortedMap<Long, ArrayList<InetSocketAddress>> getEnsembles() {
        return this.ensembles;
    }

    public int getEnsembleSize() {
        return this.ensembleSize;
    }

    public int getWriteQuorumSize() {
        return this.writeQuorumSize;
    }

    public int getAckQuorumSize() {
        return this.ackQuorumSize;
    }

    boolean hasPassword() {
        return this.hasPassword;
    }

    byte[] getPassword() {
        return Arrays.copyOf(this.password, this.password.length);
    }

    BookKeeper.DigestType getDigestType() {
        if (this.digestType.equals((Object)DataFormats.LedgerMetadataFormat.DigestType.HMAC)) {
            return BookKeeper.DigestType.MAC;
        }
        return BookKeeper.DigestType.CRC32;
    }

    public long getLastEntryId() {
        return this.lastEntryId;
    }

    public long getLength() {
        return this.length;
    }

    void setLength(long length) {
        this.length = length;
    }

    public boolean isClosed() {
        return this.state == DataFormats.LedgerMetadataFormat.State.CLOSED;
    }

    public boolean isInRecovery() {
        return this.state == DataFormats.LedgerMetadataFormat.State.IN_RECOVERY;
    }

    DataFormats.LedgerMetadataFormat.State getState() {
        return this.state;
    }

    void setState(DataFormats.LedgerMetadataFormat.State state) {
        this.state = state;
    }

    void markLedgerInRecovery() {
        this.state = DataFormats.LedgerMetadataFormat.State.IN_RECOVERY;
    }

    void close(long entryId) {
        this.lastEntryId = entryId;
        this.state = DataFormats.LedgerMetadataFormat.State.CLOSED;
    }

    void addEnsemble(long startEntryId, ArrayList<InetSocketAddress> ensemble) {
        assert (this.ensembles.isEmpty() || startEntryId >= this.ensembles.lastKey());
        this.ensembles.put(startEntryId, ensemble);
        this.currentEnsemble = ensemble;
    }

    ArrayList<InetSocketAddress> getEnsemble(long entryId) {
        return (ArrayList)this.ensembles.get(this.ensembles.headMap(entryId + 1L).lastKey());
    }

    long getNextEnsembleChange(long entryId) {
        SortedMap<Long, ArrayList<InetSocketAddress>> tailMap = this.ensembles.tailMap(entryId + 1L);
        if (tailMap.isEmpty()) {
            return -1L;
        }
        return tailMap.firstKey();
    }

    public byte[] serialize() {
        if (this.metadataFormatVersion == 1) {
            return this.serializeVersion1();
        }
        DataFormats.LedgerMetadataFormat.Builder builder = DataFormats.LedgerMetadataFormat.newBuilder();
        builder.setQuorumSize(this.writeQuorumSize).setAckQuorumSize(this.ackQuorumSize).setEnsembleSize(this.ensembleSize).setLength(this.length).setState(this.state).setLastEntryId(this.lastEntryId);
        if (this.hasPassword) {
            builder.setDigestType(this.digestType).setPassword(ByteString.copyFrom((byte[])this.password));
        }
        for (Map.Entry<Long, ArrayList<InetSocketAddress>> entry : this.ensembles.entrySet()) {
            DataFormats.LedgerMetadataFormat.Segment.Builder segmentBuilder = DataFormats.LedgerMetadataFormat.Segment.newBuilder();
            segmentBuilder.setFirstEntryId(entry.getKey());
            for (InetSocketAddress addr : entry.getValue()) {
                segmentBuilder.addEnsembleMember(addr.getAddress().getHostAddress() + ":" + addr.getPort());
            }
            builder.addSegment(segmentBuilder.build());
        }
        StringBuilder s = new StringBuilder();
        s.append(VERSION_KEY).append(tSplitter).append(2).append(lSplitter);
        s.append(TextFormat.printToString((Message)builder.build()));
        LOG.debug("Serialized config: {}", (Object)s);
        return s.toString().getBytes();
    }

    private byte[] serializeVersion1() {
        StringBuilder s = new StringBuilder();
        s.append(VERSION_KEY).append(tSplitter).append(this.metadataFormatVersion).append(lSplitter);
        s.append(this.writeQuorumSize).append(lSplitter).append(this.ensembleSize).append(lSplitter).append(this.length);
        for (Map.Entry<Long, ArrayList<InetSocketAddress>> entry : this.ensembles.entrySet()) {
            s.append(lSplitter).append(entry.getKey());
            for (InetSocketAddress addr : entry.getValue()) {
                s.append(tSplitter);
                s.append(StringUtils.addrToString(addr));
            }
        }
        if (this.state == DataFormats.LedgerMetadataFormat.State.IN_RECOVERY) {
            s.append(lSplitter).append(-102).append(tSplitter).append(closed);
        } else if (this.state == DataFormats.LedgerMetadataFormat.State.CLOSED) {
            s.append(lSplitter).append(this.getLastEntryId()).append(tSplitter).append(closed);
        }
        LOG.debug("Serialized config: {}", (Object)s);
        return s.toString().getBytes();
    }

    public static LedgerMetadata parseConfig(byte[] bytes, Version version) throws IOException {
        LedgerMetadata lc = new LedgerMetadata();
        lc.version = version;
        String config = new String(bytes);
        LOG.debug("Parsing Config: {}", (Object)config);
        BufferedReader reader = new BufferedReader(new StringReader(config));
        String versionLine = reader.readLine();
        if (versionLine == null) {
            throw new IOException("Invalid metadata. Content missing");
        }
        boolean i = false;
        if (versionLine.startsWith(VERSION_KEY)) {
            String[] parts = versionLine.split(tSplitter);
            lc.metadataFormatVersion = new Integer(parts[1]);
        } else {
            lc.metadataFormatVersion = 1;
            reader.close();
            reader = new BufferedReader(new StringReader(config));
        }
        if (lc.metadataFormatVersion < 0 || lc.metadataFormatVersion > 2) {
            throw new IOException("Metadata version not compatible. Expected between 0 and 2, but got " + lc.metadataFormatVersion);
        }
        if (lc.metadataFormatVersion == 1) {
            return LedgerMetadata.parseVersion1Config(lc, reader);
        }
        DataFormats.LedgerMetadataFormat.Builder builder = DataFormats.LedgerMetadataFormat.newBuilder();
        TextFormat.merge((Readable)reader, (Message.Builder)builder);
        DataFormats.LedgerMetadataFormat data = builder.build();
        lc.writeQuorumSize = data.getQuorumSize();
        lc.ackQuorumSize = data.hasAckQuorumSize() ? data.getAckQuorumSize() : lc.writeQuorumSize;
        lc.ensembleSize = data.getEnsembleSize();
        lc.length = data.getLength();
        lc.state = data.getState();
        lc.lastEntryId = data.getLastEntryId();
        if (data.hasPassword()) {
            lc.digestType = data.getDigestType();
            lc.password = data.getPassword().toByteArray();
            lc.hasPassword = true;
        }
        for (DataFormats.LedgerMetadataFormat.Segment s : data.getSegmentList()) {
            ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
            for (String member : s.getEnsembleMemberList()) {
                addrs.add(StringUtils.parseAddr(member));
            }
            lc.addEnsemble(s.getFirstEntryId(), addrs);
        }
        return lc;
    }

    static LedgerMetadata parseVersion1Config(LedgerMetadata lc, BufferedReader reader) throws IOException {
        try {
            lc.writeQuorumSize = lc.ackQuorumSize = new Integer(reader.readLine()).intValue();
            lc.ensembleSize = new Integer(reader.readLine());
            lc.length = new Long(reader.readLine());
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(tSplitter);
                if (parts[1].equals(closed)) {
                    Long l = new Long(parts[0]);
                    if (l == -102L) {
                        lc.state = DataFormats.LedgerMetadataFormat.State.IN_RECOVERY;
                    } else {
                        lc.state = DataFormats.LedgerMetadataFormat.State.CLOSED;
                        lc.lastEntryId = l;
                    }
                    break;
                }
                lc.state = DataFormats.LedgerMetadataFormat.State.OPEN;
                ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
                for (int j = 1; j < parts.length; ++j) {
                    addrs.add(StringUtils.parseAddr(parts[j]));
                }
                lc.addEnsemble(new Long(parts[0]), addrs);
                line = reader.readLine();
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return lc;
    }

    public void setVersion(Version v) {
        this.version = v;
    }

    public Version getVersion() {
        return this.version;
    }

    boolean resolveConflict(LedgerMetadata newMeta) {
        if (this.metadataFormatVersion != newMeta.metadataFormatVersion || this.ensembleSize != newMeta.ensembleSize || this.writeQuorumSize != newMeta.writeQuorumSize || this.ackQuorumSize != newMeta.ackQuorumSize || this.length != newMeta.length || this.state != newMeta.state || !this.digestType.equals((Object)newMeta.digestType) || !Arrays.equals(this.password, newMeta.password)) {
            return false;
        }
        if (this.state == DataFormats.LedgerMetadataFormat.State.CLOSED && this.lastEntryId != newMeta.lastEntryId) {
            return false;
        }
        if (null != this.version && Version.Occurred.AFTER == this.version.compare(newMeta.version)) {
            return false;
        }
        if (newMeta.state != DataFormats.LedgerMetadataFormat.State.CLOSED) {
            if (this.ensembles.size() != newMeta.ensembles.size()) {
                return false;
            }
            Iterator<Long> keyIter = this.ensembles.keySet().iterator();
            Iterator<Long> newMetaKeyIter = newMeta.ensembles.keySet().iterator();
            for (int i = 0; i < this.ensembles.size(); ++i) {
                Long newMetaKey;
                Long curKey = keyIter.next();
                if (curKey.equals(newMetaKey = newMetaKeyIter.next())) continue;
                return false;
            }
        }
        this.ensembles = newMeta.ensembles;
        this.version = newMeta.version;
        return true;
    }
}

