/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.bk_v4_2_0.bookkeeper.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.client.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.client.BKException;
import org.apache.bk_v4_2_0.bookkeeper.client.BookKeeper;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerEntry;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerFragment;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerHandle;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerMetadata;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bk_v4_2_0.bookkeeper.util.OrderedSafeExecutor;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerFragmentReplicator {
    private BookKeeper bkc;
    private static Logger LOG = LoggerFactory.getLogger(LedgerFragmentReplicator.class);

    public LedgerFragmentReplicator(BookKeeper bkc) {
        this.bkc = bkc;
    }

    private void replicateFragmentInternal(LedgerHandle lh, LedgerFragment lf, AsyncCallback.VoidCallback ledgerFragmentMcb, InetSocketAddress newBookie) throws InterruptedException {
        if (!lf.isClosed()) {
            LOG.error("Trying to replicate an unclosed fragment; This is not safe {}", (Object)lf);
            ledgerFragmentMcb.processResult(-103, null, null);
            return;
        }
        Long startEntryId = lf.getFirstStoredEntryId();
        Long endEntryId = lf.getLastStoredEntryId();
        if (endEntryId == null) {
            LOG.warn("Dead bookie (" + lf.getAddress() + ") is still part of the current" + " active ensemble for ledgerId: " + lh.getId());
            ledgerFragmentMcb.processResult(0, null, null);
            return;
        }
        if (startEntryId > endEntryId) {
            ledgerFragmentMcb.processResult(0, null, null);
            return;
        }
        LinkedList<Long> entriesToReplicate = new LinkedList<Long>();
        long lastStoredEntryId = lf.getLastStoredEntryId();
        for (long i = lf.getFirstStoredEntryId(); i <= lastStoredEntryId; ++i) {
            entriesToReplicate.add(i);
        }
        BookkeeperInternalCallbacks.MultiCallback ledgerFragmentEntryMcb = new BookkeeperInternalCallbacks.MultiCallback(entriesToReplicate.size(), ledgerFragmentMcb, null, 0, -10);
        for (Long entryId : entriesToReplicate) {
            this.recoverLedgerFragmentEntry(entryId, lh, ledgerFragmentEntryMcb, newBookie);
        }
    }

    void replicate(LedgerHandle lh, LedgerFragment lf, AsyncCallback.VoidCallback ledgerFragmentMcb, InetSocketAddress targetBookieAddress) throws InterruptedException {
        Set<LedgerFragment> partionedFragments = LedgerFragmentReplicator.splitIntoSubFragments(lh, lf, this.bkc.getConf().getRereplicationEntryBatchSize());
        LOG.info("Fragment :" + lf + " is split into sub fragments :" + partionedFragments);
        this.replicateNextBatch(lh, partionedFragments.iterator(), ledgerFragmentMcb, targetBookieAddress);
    }

    private void replicateNextBatch(final LedgerHandle lh, final Iterator<LedgerFragment> fragments, final AsyncCallback.VoidCallback ledgerFragmentMcb, final InetSocketAddress targetBookieAddress) {
        if (fragments.hasNext()) {
            try {
                this.replicateFragmentInternal(lh, fragments.next(), new AsyncCallback.VoidCallback(){

                    @Override
                    public void processResult(int rc, String v, Object ctx) {
                        if (rc != 0) {
                            ledgerFragmentMcb.processResult(rc, null, null);
                        } else {
                            LedgerFragmentReplicator.this.replicateNextBatch(lh, fragments, ledgerFragmentMcb, targetBookieAddress);
                        }
                    }
                }, targetBookieAddress);
            }
            catch (InterruptedException e) {
                ledgerFragmentMcb.processResult(-15, null, null);
                Thread.currentThread().interrupt();
            }
        } else {
            ledgerFragmentMcb.processResult(0, null, null);
        }
    }

    static Set<LedgerFragment> splitIntoSubFragments(LedgerHandle lh, LedgerFragment ledgerFragment, long rereplicationEntryBatchSize) {
        HashSet<LedgerFragment> fragments = new HashSet<LedgerFragment>();
        if (rereplicationEntryBatchSize <= 0L) {
            fragments.add(ledgerFragment);
            return fragments;
        }
        long firstEntryId = ledgerFragment.getFirstStoredEntryId();
        long lastEntryId = ledgerFragment.getLastStoredEntryId();
        long numberOfEntriesToReplicate = lastEntryId - firstEntryId + 1L;
        long splitsWithFullEntries = numberOfEntriesToReplicate / rereplicationEntryBatchSize;
        if (splitsWithFullEntries == 0L) {
            fragments.add(ledgerFragment);
            return fragments;
        }
        long fragmentSplitLastEntry = 0L;
        int i = 0;
        while ((long)i < splitsWithFullEntries) {
            fragmentSplitLastEntry = firstEntryId + rereplicationEntryBatchSize - 1L;
            fragments.add(new LedgerFragment(lh, firstEntryId, fragmentSplitLastEntry, ledgerFragment.getBookiesIndex()));
            firstEntryId = fragmentSplitLastEntry + 1L;
            ++i;
        }
        long lastSplitWithPartialEntries = numberOfEntriesToReplicate % rereplicationEntryBatchSize;
        if (lastSplitWithPartialEntries > 0L) {
            fragments.add(new LedgerFragment(lh, firstEntryId, firstEntryId + lastSplitWithPartialEntries - 1L, ledgerFragment.getBookiesIndex()));
        }
        return fragments;
    }

    private void recoverLedgerFragmentEntry(final Long entryId, LedgerHandle lh, final AsyncCallback.VoidCallback ledgerFragmentEntryMcb, final InetSocketAddress newBookie) throws InterruptedException {
        lh.asyncReadEntries(entryId, entryId, new AsyncCallback.ReadCallback(){

            @Override
            public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("BK error reading ledger entry: " + entryId, (Throwable)BKException.create(rc));
                    ledgerFragmentEntryMcb.processResult(rc, null, null);
                    return;
                }
                LedgerEntry entry = seq.nextElement();
                byte[] data = entry.getEntry();
                ChannelBuffer toSend = lh.getDigestManager().computeDigestAndPackageForSending(entryId, lh.getLastAddConfirmed(), entry.getLength(), data, 0, data.length);
                LedgerFragmentReplicator.this.bkc.getBookieClient().addEntry(newBookie, lh.getId(), lh.getLedgerKey(), entryId, toSend, new BookkeeperInternalCallbacks.WriteCallback(){

                    @Override
                    public void writeComplete(int rc, long ledgerId, long entryId, InetSocketAddress addr, Object ctx) {
                        if (rc != KeeperException.Code.OK.intValue()) {
                            LOG.error("BK error writing entry for ledgerId: " + ledgerId + ", entryId: " + entryId + ", bookie: " + addr, (Throwable)BKException.create(rc));
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Success writing ledger id " + ledgerId + ", entry id " + entryId + " to a new bookie " + addr + "!");
                        }
                        ledgerFragmentEntryMcb.processResult(rc, null, null);
                    }
                }, null, 2);
            }
        }, null);
    }

    private static void updateEnsembleInfo(AsyncCallback.VoidCallback ensembleUpdatedCb, long fragmentStartId, LedgerHandle lh, InetSocketAddress oldBookie, InetSocketAddress newBookie) {
        ArrayList ensemble = (ArrayList)lh.getLedgerMetadata().getEnsembles().get(fragmentStartId);
        int deadBookieIndex = ensemble.indexOf(oldBookie);
        ensemble.remove(deadBookieIndex);
        ensemble.add(deadBookieIndex, newBookie);
        lh.writeLedgerConfig(new UpdateEnsembleCb(ensembleUpdatedCb, fragmentStartId, lh, oldBookie, newBookie));
    }

    private static class UpdateEnsembleCb
    implements BookkeeperInternalCallbacks.GenericCallback<Void> {
        final AsyncCallback.VoidCallback ensembleUpdatedCb;
        final LedgerHandle lh;
        final long fragmentStartId;
        final InetSocketAddress oldBookie;
        final InetSocketAddress newBookie;

        public UpdateEnsembleCb(AsyncCallback.VoidCallback ledgerFragmentsMcb, long fragmentStartId, LedgerHandle lh, InetSocketAddress oldBookie, InetSocketAddress newBookie) {
            this.ensembleUpdatedCb = ledgerFragmentsMcb;
            this.lh = lh;
            this.fragmentStartId = fragmentStartId;
            this.newBookie = newBookie;
            this.oldBookie = oldBookie;
        }

        @Override
        public void operationComplete(int rc, Void result) {
            if (rc == -17) {
                LOG.warn("Two fragments attempted update at once; ledger id: " + this.lh.getId() + " startid: " + this.fragmentStartId);
                this.lh.rereadMetadata((BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata>)new OrderedSafeExecutor.OrderedSafeGenericCallback<LedgerMetadata>(this.lh.bk.mainWorkerPool, (Object)this.lh.getId()){

                    @Override
                    public void safeOperationComplete(int rc, LedgerMetadata newMeta) {
                        if (rc != 0) {
                            LOG.error("Error reading updated ledger metadata for ledger " + UpdateEnsembleCb.this.lh.getId());
                            UpdateEnsembleCb.this.ensembleUpdatedCb.processResult(rc, null, null);
                        } else {
                            UpdateEnsembleCb.this.lh.metadata = newMeta;
                            LedgerFragmentReplicator.updateEnsembleInfo(UpdateEnsembleCb.this.ensembleUpdatedCb, UpdateEnsembleCb.this.fragmentStartId, UpdateEnsembleCb.this.lh, UpdateEnsembleCb.this.oldBookie, UpdateEnsembleCb.this.newBookie);
                        }
                    }
                });
                return;
            }
            if (rc != 0) {
                LOG.error("Error updating ledger config metadata for ledgerId " + this.lh.getId() + " : " + BKException.getMessage(rc));
            } else {
                LOG.info("Updated ZK for ledgerId: (" + this.lh.getId() + " : " + this.fragmentStartId + ") to point ledger fragments from old dead bookie: (" + this.oldBookie + ") to new bookie: (" + this.newBookie + ")");
            }
            this.ensembleUpdatedCb.processResult(rc, null, null);
        }
    }

    static class SingleFragmentCallback
    implements AsyncCallback.VoidCallback {
        final AsyncCallback.VoidCallback ledgerFragmentsMcb;
        final LedgerHandle lh;
        final long fragmentStartId;
        final InetSocketAddress oldBookie;
        final InetSocketAddress newBookie;

        SingleFragmentCallback(AsyncCallback.VoidCallback ledgerFragmentsMcb, LedgerHandle lh, long fragmentStartId, InetSocketAddress oldBookie, InetSocketAddress newBookie) {
            this.ledgerFragmentsMcb = ledgerFragmentsMcb;
            this.lh = lh;
            this.fragmentStartId = fragmentStartId;
            this.newBookie = newBookie;
            this.oldBookie = oldBookie;
        }

        @Override
        public void processResult(int rc, String path, Object ctx) {
            if (rc != KeeperException.Code.OK.intValue()) {
                LOG.error("BK error replicating ledger fragments for ledger: " + this.lh.getId(), (Throwable)BKException.create(rc));
                this.ledgerFragmentsMcb.processResult(rc, null, null);
                return;
            }
            LedgerFragmentReplicator.updateEnsembleInfo(this.ledgerFragmentsMcb, this.fragmentStartId, this.lh, this.oldBookie, this.newBookie);
        }
    }
}

