/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import org.apache.bk_v4_2_0.bookkeeper.client.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.client.BKException;
import org.apache.bk_v4_2_0.bookkeeper.client.BookKeeper;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerHandle;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerMetadata;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerCreateOp
implements BookkeeperInternalCallbacks.GenericCallback<Long> {
    static final Logger LOG = LoggerFactory.getLogger(LedgerCreateOp.class);
    AsyncCallback.CreateCallback cb;
    LedgerMetadata metadata;
    LedgerHandle lh;
    Object ctx;
    byte[] passwd;
    BookKeeper bk;
    BookKeeper.DigestType digestType;

    LedgerCreateOp(BookKeeper bk, int ensembleSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) {
        this.bk = bk;
        this.metadata = new LedgerMetadata(ensembleSize, writeQuorumSize, ackQuorumSize, digestType, passwd);
        this.digestType = digestType;
        this.passwd = passwd;
        this.cb = cb;
        this.ctx = ctx;
    }

    public void initiate() {
        ArrayList<InetSocketAddress> ensemble;
        try {
            ensemble = this.bk.bookieWatcher.getNewBookies(this.metadata.getEnsembleSize());
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            LOG.error("Not enough bookies to create ledger");
            this.cb.createComplete(e.getCode(), null, this.ctx);
            return;
        }
        this.metadata.addEnsemble(0L, ensemble);
        this.bk.getLedgerManager().createLedger(this.metadata, this);
    }

    @Override
    public void operationComplete(int rc, Long ledgerId) {
        if (0 != rc) {
            this.cb.createComplete(rc, null, this.ctx);
            return;
        }
        try {
            this.lh = new LedgerHandle(this.bk, ledgerId, this.metadata, this.digestType, this.passwd);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Security exception while creating ledger: " + ledgerId, (Throwable)e);
            this.cb.createComplete(-4, null, this.ctx);
            return;
        }
        catch (NumberFormatException e) {
            LOG.error("Incorrectly entered parameter throttle: " + this.bk.getConf().getThrottleValue(), (Throwable)e);
            this.cb.createComplete(-14, null, this.ctx);
            return;
        }
        this.cb.createComplete(0, this.lh, this.ctx);
    }
}

