/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.bk_v4_2_0.bookkeeper.client.DigestManager;

class CRC32DigestManager
extends DigestManager {
    private final ThreadLocal<CRC32> crc = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };

    public CRC32DigestManager(long ledgerId) {
        super(ledgerId);
    }

    @Override
    int getMacCodeLength() {
        return 8;
    }

    @Override
    byte[] getValueAndReset() {
        byte[] value = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(value);
        buf.putLong(this.crc.get().getValue());
        this.crc.get().reset();
        return value;
    }

    @Override
    void update(byte[] data, int offset, int length) {
        this.crc.get().update(data, offset, length);
    }
}

