/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.bk_v4_2_0.bookkeeper.bookie.Bookie;
import org.apache.bk_v4_2_0.bookkeeper.bookie.BookieException;
import org.apache.bk_v4_2_0.bookkeeper.bookie.LedgerDescriptorImpl;
import org.apache.bk_v4_2_0.bookkeeper.bookie.LedgerDescriptorReadOnlyImpl;
import org.apache.bk_v4_2_0.bookkeeper.bookie.LedgerStorage;

public abstract class LedgerDescriptor {
    static LedgerDescriptor create(byte[] masterKey, long ledgerId, LedgerStorage ledgerStorage) throws IOException {
        LedgerDescriptorImpl ledger = new LedgerDescriptorImpl(masterKey, ledgerId, ledgerStorage);
        ledgerStorage.setMasterKey(ledgerId, masterKey);
        return ledger;
    }

    static LedgerDescriptor createReadOnly(long ledgerId, LedgerStorage ledgerStorage) throws IOException, Bookie.NoLedgerException {
        if (!ledgerStorage.ledgerExists(ledgerId)) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
        return new LedgerDescriptorReadOnlyImpl(ledgerId, ledgerStorage);
    }

    abstract void checkAccess(byte[] var1) throws BookieException, IOException;

    abstract long getLedgerId();

    abstract boolean setFenced() throws IOException;

    abstract boolean isFenced() throws IOException;

    abstract long addEntry(ByteBuffer var1) throws IOException;

    abstract ByteBuffer readEntry(long var1) throws IOException;
}

