/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bk_v4_2_0.bookkeeper.bookie.EntryLogger;
import org.apache.bk_v4_2_0.bookkeeper.bookie.GarbageCollector;
import org.apache.bk_v4_2_0.bookkeeper.bookie.LedgerCache;
import org.apache.bk_v4_2_0.bookkeeper.bookie.ScanAndCompareGarbageCollector;
import org.apache.bk_v4_2_0.bookkeeper.conf.ServerConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.meta.LedgerManager;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bk_v4_2_0.bookkeeper.util.MathUtils;
import org.apache.bk_v4_2_0.bookkeeper.util.SnapshotMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectorThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(GarbageCollectorThread.class);
    private static final int COMPACTION_MAX_OUTSTANDING_REQUESTS = 1000;
    private static final int SECOND = 1000;
    private Map<Long, EntryLogMetadata> entryLogMetaMap = new ConcurrentHashMap<Long, EntryLogMetadata>();
    final long gcWaitTime;
    boolean enableMinorCompaction = false;
    final double minorCompactionThreshold;
    final long minorCompactionInterval;
    boolean enableMajorCompaction = false;
    final double majorCompactionThreshold;
    final long majorCompactionInterval;
    long lastMinorCompactionTime;
    long lastMajorCompactionTime;
    final EntryLogger entryLogger;
    final SafeEntryAdder safeEntryAdder;
    final LedgerCache ledgerCache;
    final SnapshotMap<Long, Boolean> activeLedgers;
    final AtomicBoolean compacting = new AtomicBoolean(false);
    volatile boolean running = true;
    long scannedLogId = 0L;
    final GarbageCollector garbageCollector;
    final GarbageCollector.GarbageCleaner garbageCleaner;

    public GarbageCollectorThread(ServerConfiguration conf, final LedgerCache ledgerCache, EntryLogger entryLogger, SnapshotMap<Long, Boolean> activeLedgers, SafeEntryAdder safeEntryAdder, LedgerManager ledgerManager) throws IOException {
        super("GarbageCollectorThread");
        this.ledgerCache = ledgerCache;
        this.entryLogger = entryLogger;
        this.activeLedgers = activeLedgers;
        this.safeEntryAdder = safeEntryAdder;
        this.gcWaitTime = conf.getGcWaitTime();
        this.garbageCleaner = new GarbageCollector.GarbageCleaner(){

            @Override
            public void clean(long ledgerId) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("delete ledger : " + ledgerId);
                    }
                    ledgerCache.deleteLedger(ledgerId);
                }
                catch (IOException e) {
                    LOG.error("Exception when deleting the ledger index file on the Bookie: ", (Throwable)e);
                }
            }
        };
        this.garbageCollector = new ScanAndCompareGarbageCollector(ledgerManager, activeLedgers);
        this.minorCompactionThreshold = conf.getMinorCompactionThreshold();
        this.minorCompactionInterval = conf.getMinorCompactionInterval() * 1000L;
        this.majorCompactionThreshold = conf.getMajorCompactionThreshold();
        this.majorCompactionInterval = conf.getMajorCompactionInterval() * 1000L;
        if (this.minorCompactionInterval > 0L && this.minorCompactionThreshold > 0.0) {
            if (this.minorCompactionThreshold > 1.0) {
                throw new IOException("Invalid minor compaction threshold " + this.minorCompactionThreshold);
            }
            if (this.minorCompactionInterval <= this.gcWaitTime) {
                throw new IOException("Too short minor compaction interval : " + this.minorCompactionInterval);
            }
            this.enableMinorCompaction = true;
        }
        if (this.majorCompactionInterval > 0L && this.majorCompactionThreshold > 0.0) {
            if (this.majorCompactionThreshold > 1.0) {
                throw new IOException("Invalid major compaction threshold " + this.majorCompactionThreshold);
            }
            if (this.majorCompactionInterval <= this.gcWaitTime) {
                throw new IOException("Too short major compaction interval : " + this.majorCompactionInterval);
            }
            this.enableMajorCompaction = true;
        }
        if (this.enableMinorCompaction && this.enableMajorCompaction && (this.minorCompactionInterval >= this.majorCompactionInterval || this.minorCompactionThreshold >= this.majorCompactionThreshold)) {
            throw new IOException("Invalid minor/major compaction settings : minor (" + this.minorCompactionThreshold + ", " + this.minorCompactionInterval + "), major (" + this.majorCompactionThreshold + ", " + this.majorCompactionInterval + ")");
        }
        LOG.info("Minor Compaction : enabled=" + this.enableMinorCompaction + ", threshold=" + this.minorCompactionThreshold + ", interval=" + this.minorCompactionInterval);
        LOG.info("Major Compaction : enabled=" + this.enableMajorCompaction + ", threshold=" + this.majorCompactionThreshold + ", interval=" + this.majorCompactionInterval);
        this.lastMinorCompactionTime = this.lastMajorCompactionTime = MathUtils.now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            GarbageCollectorThread garbageCollectorThread = this;
            synchronized (garbageCollectorThread) {
                try {
                    this.wait(this.gcWaitTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            this.entryLogMetaMap = this.extractMetaFromEntryLogs(this.entryLogMetaMap);
            this.doGcLedgers();
            this.doGcEntryLogs();
            long curTime = MathUtils.now();
            if (this.enableMajorCompaction && curTime - this.lastMajorCompactionTime > this.majorCompactionInterval) {
                LOG.info("Enter major compaction");
                this.doCompactEntryLogs(this.majorCompactionThreshold);
                this.lastMinorCompactionTime = this.lastMajorCompactionTime = MathUtils.now();
                continue;
            }
            if (!this.enableMinorCompaction || curTime - this.lastMinorCompactionTime <= this.minorCompactionInterval) continue;
            LOG.info("Enter minor compaction");
            this.doCompactEntryLogs(this.minorCompactionThreshold);
            this.lastMinorCompactionTime = MathUtils.now();
        }
    }

    private void doGcLedgers() {
        this.garbageCollector.gc(this.garbageCleaner);
    }

    private void doGcEntryLogs() {
        for (Long entryLogId : this.entryLogMetaMap.keySet()) {
            EntryLogMetadata meta = this.entryLogMetaMap.get(entryLogId);
            for (Long entryLogLedger : meta.ledgersMap.keySet()) {
                if (this.activeLedgers.containsKey(entryLogLedger)) continue;
                meta.removeLedger(entryLogLedger);
            }
            if (!meta.isEmpty()) continue;
            LOG.info("Deleting entryLogId " + entryLogId + " as it has no active ledgers!");
            this.removeEntryLog(entryLogId);
        }
    }

    private void doCompactEntryLogs(double threshold) {
        EntryLogMetadata meta;
        LOG.info("Do compaction to compact those files lower than " + threshold);
        Comparator<EntryLogMetadata> sizeComparator = new Comparator<EntryLogMetadata>(){

            @Override
            public int compare(EntryLogMetadata m1, EntryLogMetadata m2) {
                long unusedSize1 = m1.totalSize - m1.remainingSize;
                long unusedSize2 = m2.totalSize - m2.remainingSize;
                if (unusedSize1 > unusedSize2) {
                    return -1;
                }
                if (unusedSize1 < unusedSize2) {
                    return 1;
                }
                return 0;
            }
        };
        ArrayList<EntryLogMetadata> logsToCompact = new ArrayList<EntryLogMetadata>();
        logsToCompact.addAll(this.entryLogMetaMap.values());
        Collections.sort(logsToCompact, sizeComparator);
        Iterator i$ = logsToCompact.iterator();
        while (i$.hasNext() && !((meta = (EntryLogMetadata)i$.next()).getUsage() >= threshold)) {
            LOG.debug("Compacting entry log {} below threshold {}.", (Object)meta.entryLogId, (Object)threshold);
            this.compactEntryLog(meta.entryLogId);
            if (this.running) continue;
            return;
        }
    }

    public void shutdown() throws InterruptedException {
        this.running = false;
        if (this.compacting.compareAndSet(false, true)) {
            this.interrupt();
        }
        this.join();
    }

    private void removeEntryLog(long entryLogId) {
        if (this.entryLogger.removeEntryLog(entryLogId)) {
            this.entryLogMetaMap.remove(entryLogId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compactEntryLog(long entryLogId) {
        EntryLogMetadata entryLogMeta = this.entryLogMetaMap.get(entryLogId);
        if (null == entryLogMeta) {
            LOG.warn("Can't get entry log meta when compacting entry log " + entryLogId + ".");
            return;
        }
        if (!this.compacting.compareAndSet(false, true)) {
            return;
        }
        LOG.info("Compacting entry log : " + entryLogId);
        try {
            CompactionScanner scanner = new CompactionScanner(entryLogMeta);
            this.entryLogger.scanEntryLog(entryLogId, scanner);
            scanner.awaitComplete();
            this.removeEntryLog(entryLogId);
        }
        catch (IOException e) {
            LOG.info("Premature exception when compacting " + entryLogId, (Throwable)e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted while compacting", (Throwable)ie);
        }
        finally {
            this.compacting.set(false);
        }
    }

    protected Map<Long, EntryLogMetadata> extractMetaFromEntryLogs(Map<Long, EntryLogMetadata> entryLogMetaMap) {
        long curLogId = this.entryLogger.getCurrentLogId();
        boolean hasExceptionWhenScan = false;
        for (long entryLogId = this.scannedLogId; entryLogId < curLogId; ++entryLogId) {
            if (entryLogMetaMap.containsKey(entryLogId) || !this.entryLogger.logExists(entryLogId)) continue;
            LOG.info("Extracting entry log meta from entryLogId: " + entryLogId);
            try {
                EntryLogMetadata entryLogMeta = GarbageCollectorThread.extractMetaFromEntryLog(this.entryLogger, entryLogId);
                entryLogMetaMap.put(entryLogId, entryLogMeta);
            }
            catch (IOException e) {
                hasExceptionWhenScan = true;
                LOG.warn("Premature exception when processing " + entryLogId + " recovery will take care of the problem", (Throwable)e);
            }
            if (hasExceptionWhenScan) continue;
            ++this.scannedLogId;
        }
        return entryLogMetaMap;
    }

    static EntryLogMetadata extractMetaFromEntryLog(EntryLogger entryLogger, long entryLogId) throws IOException {
        EntryLogMetadata entryLogMeta = new EntryLogMetadata(entryLogId);
        ExtractionScanner scanner = new ExtractionScanner(entryLogMeta);
        entryLogger.scanEntryLog(entryLogId, scanner);
        LOG.info("Retrieved entry log meta data entryLogId: " + entryLogId + ", meta: " + entryLogMeta);
        return entryLogMeta;
    }

    static class ExtractionScanner
    implements EntryLogger.EntryLogScanner {
        EntryLogMetadata meta;

        public ExtractionScanner(EntryLogMetadata meta) {
            this.meta = meta;
        }

        @Override
        public boolean accept(long ledgerId) {
            return true;
        }

        @Override
        public void process(long ledgerId, long offset, ByteBuffer entry) {
            this.meta.addLedgerSize(ledgerId, entry.limit() + 4);
        }
    }

    static class EntryLogMetadata {
        long entryLogId;
        long totalSize;
        long remainingSize;
        ConcurrentHashMap<Long, Long> ledgersMap;

        public EntryLogMetadata(long logId) {
            this.entryLogId = logId;
            this.remainingSize = 0L;
            this.totalSize = 0L;
            this.ledgersMap = new ConcurrentHashMap();
        }

        public void addLedgerSize(long ledgerId, long size) {
            this.totalSize += size;
            this.remainingSize += size;
            Long ledgerSize = this.ledgersMap.get(ledgerId);
            if (null == ledgerSize) {
                ledgerSize = 0L;
            }
            ledgerSize = ledgerSize + size;
            this.ledgersMap.put(ledgerId, ledgerSize);
        }

        public void removeLedger(long ledgerId) {
            Long size = this.ledgersMap.remove(ledgerId);
            if (null == size) {
                return;
            }
            this.remainingSize -= size.longValue();
        }

        public boolean containsLedger(long ledgerId) {
            return this.ledgersMap.containsKey(ledgerId);
        }

        public double getUsage() {
            if (this.totalSize == 0L) {
                return 0.0;
            }
            return (double)this.remainingSize / (double)this.totalSize;
        }

        public boolean isEmpty() {
            return this.ledgersMap.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ totalSize = ").append(this.totalSize).append(", remainingSize = ").append(this.remainingSize).append(", ledgersMap = ").append(this.ledgersMap).append(" }");
            return sb.toString();
        }
    }

    class CompactionScanner
    implements EntryLogger.EntryLogScanner {
        EntryLogMetadata meta;
        Object completionLock = new Object();
        AtomicInteger outstandingRequests = new AtomicInteger(0);
        AtomicBoolean allSuccessful = new AtomicBoolean(true);

        public CompactionScanner(EntryLogMetadata meta) {
            this.meta = meta;
        }

        @Override
        public boolean accept(long ledgerId) {
            return this.meta.containsLedger(ledgerId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(final long ledgerId, long offset, ByteBuffer entry) throws IOException {
            if (!this.allSuccessful.get()) {
                return;
            }
            this.outstandingRequests.incrementAndGet();
            Object object = this.completionLock;
            synchronized (object) {
                while (this.outstandingRequests.get() >= 1000) {
                    try {
                        this.completionLock.wait();
                    }
                    catch (InterruptedException ie) {
                        LOG.error("Interrupted while waiting to re-add entry", (Throwable)ie);
                        Thread.currentThread().interrupt();
                        throw new IOException("Interrupted while waiting to re-add entry", ie);
                    }
                }
            }
            GarbageCollectorThread.this.safeEntryAdder.safeAddEntry(ledgerId, entry, new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(int rc, Void result) {
                    if (rc != 0) {
                        LOG.error("Error {} re-adding entry for ledger {})", (Object)rc, (Object)ledgerId);
                        CompactionScanner.this.allSuccessful.set(false);
                    }
                    Object object = CompactionScanner.this.completionLock;
                    synchronized (object) {
                        CompactionScanner.this.outstandingRequests.decrementAndGet();
                        CompactionScanner.this.completionLock.notifyAll();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitComplete() throws InterruptedException, IOException {
            Object object = this.completionLock;
            synchronized (object) {
                while (this.outstandingRequests.get() > 0) {
                    this.completionLock.wait();
                }
                if (!this.allSuccessful.get()) {
                    throw new IOException("Couldn't re-add all entries");
                }
            }
        }
    }

    static interface SafeEntryAdder {
        public void safeAddEntry(long var1, ByteBuffer var3, BookkeeperInternalCallbacks.GenericCallback<Void> var4);
    }
}

