/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.WatchedEvent;
import org.apache.bk_v4_2_0.bookkeeper.Watcher;
import org.apache.bk_v4_2_0.bookkeeper.ZooKeeper;
import org.apache.bk_v4_2_0.bookkeeper.bookie.BookieException;
import org.apache.bk_v4_2_0.bookkeeper.bookie.Cookie;
import org.apache.bk_v4_2_0.bookkeeper.conf.ServerConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.util.HardLink;
import org.apache.bk_v4_2_0.commons.cli.BasicParser;
import org.apache.bk_v4_2_0.commons.cli.CommandLine;
import org.apache.bk_v4_2_0.commons.cli.HelpFormatter;
import org.apache.bk_v4_2_0.commons.cli.Options;
import org.apache.bk_v4_2_0.commons.configuration.ConfigurationException;
import org.apache.bk_v4_2_0.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUpgrade {
    static Logger LOG = LoggerFactory.getLogger(FileSystemUpgrade.class);
    static FilenameFilter BOOKIE_FILES_FILTER = new FilenameFilter(){

        private boolean containsIndexFiles(File dir, String name) {
            if (name.endsWith(".idx")) {
                return true;
            }
            try {
                Long.parseLong(name, 16);
                File d = new File(dir, name);
                if (d.isDirectory()) {
                    String[] files;
                    for (String f : files = d.list()) {
                        if (!this.containsIndexFiles(d, f)) continue;
                        return true;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return false;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.endsWith(".txn") || name.endsWith(".log") || name.equals("lastId") || name.equals("lastMark")) {
                return true;
            }
            return this.containsIndexFiles(dir, name);
        }
    };

    private static List<File> getAllDirectories(ServerConfiguration conf) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(conf.getJournalDir());
        for (File d : conf.getLedgerDirs()) {
            dirs.add(d);
        }
        return dirs;
    }

    private static int detectPreviousVersion(File directory) throws IOException {
        String[] files = directory.list(BOOKIE_FILES_FILTER);
        File v2versionFile = new File(directory, "VERSION");
        if (files.length == 0 && !v2versionFile.exists()) {
            return 4;
        }
        if (!v2versionFile.exists()) {
            return 1;
        }
        Scanner s = new Scanner(v2versionFile);
        try {
            int n = s.nextInt();
            return n;
        }
        catch (NoSuchElementException nse) {
            LOG.error("Couldn't parse version file " + v2versionFile, (Throwable)nse);
            throw new IOException("Couldn't parse version file", nse);
        }
        catch (IllegalStateException ise) {
            LOG.error("Error reading file " + v2versionFile, (Throwable)ise);
            throw new IOException("Error reading version file", ise);
        }
        finally {
            s.close();
        }
    }

    private static ZooKeeper newZookeeper(ServerConfiguration conf) throws BookieException.UpgradeException {
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            ZooKeeper zk = new ZooKeeper(conf.getZkServers(), conf.getZkTimeout(), new Watcher(){

                @Override
                public void process(WatchedEvent event) {
                    if (event.getState().equals((Object)Watcher.Event.KeeperState.SyncConnected)) {
                        latch.countDown();
                    }
                }
            });
            if (!latch.await(conf.getZkTimeout() * 2, TimeUnit.MILLISECONDS)) {
                zk.close();
                throw new BookieException.UpgradeException("Couldn't connect to zookeeper");
            }
            return zk;
        }
        catch (InterruptedException ie) {
            throw new BookieException.UpgradeException(ie);
        }
        catch (IOException ioe) {
            throw new BookieException.UpgradeException(ioe);
        }
    }

    private static void linkIndexDirectories(File srcPath, File targetPath) throws IOException {
        String[] files;
        for (String f : files = srcPath.list()) {
            if (f.endsWith(".idx")) {
                if (!targetPath.mkdirs()) {
                    throw new IOException("Could not create target path [" + targetPath + "]");
                }
                HardLink.createHardLinkMult(srcPath, files, targetPath);
                return;
            }
            File newSrcPath = new File(srcPath, f);
            if (!newSrcPath.isDirectory()) continue;
            try {
                Long.parseLong(f, 16);
                FileSystemUpgrade.linkIndexDirectories(newSrcPath, new File(targetPath, f));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    public static void upgrade(ServerConfiguration conf) throws BookieException.UpgradeException, InterruptedException {
        LOG.info("Upgrading...");
        ZooKeeper zk = FileSystemUpgrade.newZookeeper(conf);
        try {
            HashMap<File, File> deferredMoves = new HashMap<File, File>();
            Cookie c = Cookie.generateCookie(conf);
            for (File file : FileSystemUpgrade.getAllDirectories(conf)) {
                LOG.info("Upgrading {}", (Object)file);
                int version = FileSystemUpgrade.detectPreviousVersion(file);
                if (version == 4) {
                    LOG.info("Directory is current, no need to upgrade");
                    continue;
                }
                try {
                    File curDir = new File(file, "current");
                    File tmpDir = new File(file, "upgradeTmp." + System.nanoTime());
                    deferredMoves.put(curDir, tmpDir);
                    if (!tmpDir.mkdirs()) {
                        throw new BookieException.UpgradeException("Could not create temporary directory " + tmpDir);
                    }
                    c.writeToDirectory(tmpDir);
                    String[] files = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return BOOKIE_FILES_FILTER.accept(dir, name) && !new File(dir, name).isDirectory();
                        }
                    });
                    HardLink.createHardLinkMult(file, files, tmpDir);
                    FileSystemUpgrade.linkIndexDirectories(file, tmpDir);
                }
                catch (IOException ioe) {
                    LOG.error("Error upgrading {}", (Object)file);
                    throw new BookieException.UpgradeException(ioe);
                }
            }
            for (Map.Entry entry : deferredMoves.entrySet()) {
                try {
                    FileUtils.moveDirectory((File)entry.getValue(), (File)entry.getKey());
                }
                catch (IOException ioe) {
                    String err = String.format("Error moving upgraded directories into place %s -> %s ", entry.getValue(), entry.getKey());
                    LOG.error(err, (Throwable)ioe);
                    throw new BookieException.UpgradeException(ioe);
                }
            }
            if (deferredMoves.isEmpty()) {
                return;
            }
            try {
                c.writeToZooKeeper(zk, conf);
            }
            catch (KeeperException ke) {
                LOG.error("Error writing cookie to zookeeper");
                throw new BookieException.UpgradeException(ke);
            }
        }
        catch (IOException ioe) {
            throw new BookieException.UpgradeException(ioe);
        }
        finally {
            zk.close();
        }
        LOG.info("Done");
    }

    public static void finalizeUpgrade(ServerConfiguration conf) throws BookieException.UpgradeException, InterruptedException {
        LOG.info("Finalizing upgrade...");
        for (File d : FileSystemUpgrade.getAllDirectories(conf)) {
            LOG.info("Finalizing {}", (Object)d);
            try {
                File[] files;
                File v2versionFile;
                int version = FileSystemUpgrade.detectPreviousVersion(d);
                if (version >= 3) continue;
                if (version == 2 && !(v2versionFile = new File(d, "VERSION")).delete()) {
                    LOG.warn("Could not delete old version file {}", (Object)v2versionFile);
                }
                for (File f : files = d.listFiles(BOOKIE_FILES_FILTER)) {
                    if (f.isDirectory()) {
                        FileUtils.deleteDirectory(f);
                        continue;
                    }
                    if (f.delete()) continue;
                    LOG.warn("Could not delete {}", (Object)f);
                }
            }
            catch (IOException ioe) {
                LOG.error("Error finalizing {}", (Object)d);
                throw new BookieException.UpgradeException(ioe);
            }
        }
        LOG.info("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollback(ServerConfiguration conf) throws BookieException.UpgradeException, InterruptedException {
        LOG.info("Rolling back upgrade...");
        ZooKeeper zk = FileSystemUpgrade.newZookeeper(conf);
        try {
            for (File d : FileSystemUpgrade.getAllDirectories(conf)) {
                LOG.info("Rolling back {}", (Object)d);
                try {
                    int version = FileSystemUpgrade.detectPreviousVersion(d);
                    if (version <= 4) {
                        File curDir = new File(d, "current");
                        FileUtils.deleteDirectory(curDir);
                        continue;
                    }
                    throw new BookieException.UpgradeException("Cannot rollback as previous data does not exist");
                }
                catch (IOException ioe) {
                    LOG.error("Error rolling back {}", (Object)d);
                    throw new BookieException.UpgradeException(ioe);
                }
            }
            try {
                Cookie c = Cookie.readFromZooKeeper(zk, conf);
                c.deleteFromZooKeeper(zk, conf);
            }
            catch (KeeperException ke) {
                LOG.error("Error deleting cookie from ZooKeeper");
                throw new BookieException.UpgradeException(ke);
            }
            catch (IOException ioe) {
                LOG.error("I/O Error deleting cookie from ZooKeeper");
                throw new BookieException.UpgradeException(ioe);
            }
        }
        finally {
            zk.close();
        }
        LOG.info("Done");
    }

    private static void printHelp(Options opts) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("FileSystemUpgrade [options]", opts);
    }

    public static void main(String[] args) throws Exception {
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%-5p [%t]: %m%n")));
        root.setLevel(Level.ERROR);
        org.apache.log4j.Logger.getLogger(FileSystemUpgrade.class).setLevel(Level.INFO);
        Options opts = new Options();
        opts.addOption("c", "conf", true, "Configuration for Bookie");
        opts.addOption("u", "upgrade", false, "Upgrade bookie directories");
        opts.addOption("f", "finalize", false, "Finalize upgrade");
        opts.addOption("r", "rollback", false, "Rollback upgrade");
        opts.addOption("h", "help", false, "Print help message");
        BasicParser parser = new BasicParser();
        CommandLine cmdLine = parser.parse(opts, args);
        if (cmdLine.hasOption("h")) {
            FileSystemUpgrade.printHelp(opts);
            return;
        }
        if (!cmdLine.hasOption("c")) {
            String err = "Cannot upgrade without configuration";
            LOG.error(err);
            FileSystemUpgrade.printHelp(opts);
            throw new IllegalArgumentException(err);
        }
        String confFile = cmdLine.getOptionValue("c");
        ServerConfiguration conf = new ServerConfiguration();
        try {
            conf.loadConf(new File(confFile).toURI().toURL());
        }
        catch (MalformedURLException mue) {
            LOG.error("Could not open configuration file " + confFile, (Throwable)mue);
            throw new IllegalArgumentException();
        }
        catch (ConfigurationException ce) {
            LOG.error("Invalid configuration file " + confFile, (Throwable)ce);
            throw new IllegalArgumentException();
        }
        if (cmdLine.hasOption("u")) {
            FileSystemUpgrade.upgrade(conf);
        } else if (cmdLine.hasOption("r")) {
            FileSystemUpgrade.rollback(conf);
        } else if (cmdLine.hasOption("f")) {
            FileSystemUpgrade.finalizeUpgrade(conf);
        } else {
            String err = "Must specify -upgrade, -finalize or -rollback";
            LOG.error(err);
            FileSystemUpgrade.printHelp(opts);
            throw new IllegalArgumentException(err);
        }
    }
}

