/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

public abstract class BookieException
extends Exception {
    private int code;

    public BookieException(int code) {
        this.code = code;
    }

    public BookieException(int code, Throwable t) {
        super(t);
    }

    public BookieException(int code, String reason) {
        super(reason);
    }

    public static BookieException create(int code) {
        switch (code) {
            case -1: {
                return new BookieUnauthorizedAccessException();
            }
            case -101: {
                return new LedgerFencedException();
            }
            case -102: {
                return new InvalidCookieException();
            }
            case -103: {
                return new UpgradeException();
            }
        }
        return new BookieIllegalOpException();
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage(int code) {
        String err = "Invalid operation";
        switch (code) {
            case 0: {
                err = "No problem";
                break;
            }
            case -1: {
                err = "Error while reading ledger";
                break;
            }
            case -101: {
                err = "Ledger has been fenced; No more entries can be added";
                break;
            }
            case -102: {
                err = "Invalid environment cookie found";
                break;
            }
            case -103: {
                err = "Error performing an upgrade operation ";
            }
        }
        String reason = super.getMessage();
        if (reason == null && super.getCause() != null) {
            reason = super.getCause().getMessage();
        }
        if (reason == null) {
            return err;
        }
        return String.format("%s [%s]", err, reason);
    }

    public static class UpgradeException
    extends BookieException {
        public UpgradeException() {
            super(-103);
        }

        public UpgradeException(Throwable cause) {
            super(-103, cause);
        }

        public UpgradeException(String reason) {
            super(-103, reason);
        }
    }

    public static class InvalidCookieException
    extends BookieException {
        public InvalidCookieException() {
            this("");
        }

        public InvalidCookieException(String reason) {
            super(-102, reason);
        }

        public InvalidCookieException(Throwable cause) {
            super(-102, cause);
        }
    }

    public static class LedgerFencedException
    extends BookieException {
        public LedgerFencedException() {
            super(-101);
        }
    }

    public static class BookieIllegalOpException
    extends BookieException {
        public BookieIllegalOpException() {
            super(-1);
        }
    }

    public static class BookieUnauthorizedAccessException
    extends BookieException {
        public BookieUnauthorizedAccessException() {
            super(-1);
        }
    }

    public static interface Code {
        public static final int OK = 0;
        public static final int UnauthorizedAccessException = -1;
        public static final int IllegalOpException = -100;
        public static final int LedgerFencedException = -101;
        public static final int InvalidCookieException = -102;
        public static final int UpgradeException = -103;
    }
}

