/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing.kafka;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServerStartable;
import org.apache.beam.sdk.testing.kafka.LocalZookeeper;

public class LocalKafka {
    private final KafkaServerStartable server;

    LocalKafka(int kafkaPort, int zookeeperPort) throws Exception {
        Properties kafkaProperties = new Properties();
        kafkaProperties.setProperty("port", String.valueOf(kafkaPort));
        kafkaProperties.setProperty("zookeeper.connect", String.format("localhost:%s", zookeeperPort));
        kafkaProperties.setProperty("offsets.topic.replication.factor", "1");
        kafkaProperties.setProperty("log.dir", Files.createTempDirectory("kafka-log-", new FileAttribute[0]).toString());
        this.server = new KafkaServerStartable(KafkaConfig.fromProps((Properties)kafkaProperties));
    }

    public void start() {
        this.server.startup();
    }

    public void stop() {
        this.server.shutdown();
    }

    public void awaitTermination() {
        this.server.awaitShutdown();
    }

    public static void main(String[] args) throws Exception {
        int kafkaPort = Integer.parseInt(args[0]);
        int zookeeperPort = Integer.parseInt(args[1]);
        LocalZookeeper zookeeper = new LocalZookeeper(zookeeperPort);
        LocalKafka kafka = new LocalKafka(kafkaPort, zookeeperPort);
        zookeeper.start();
        Thread.sleep(5000L);
        kafka.start();
        kafka.awaitTermination();
    }
}

