/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing.kafka;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalZookeeper {
    private static final Logger LOG = LoggerFactory.getLogger(LocalZookeeper.class);
    private final ServerConfig serverConfig;
    private final Executor executor;

    LocalZookeeper(int port) throws Exception {
        Properties localProperties = new Properties();
        localProperties.setProperty("clientPort", String.valueOf(port));
        localProperties.setProperty("dataDir", Files.createTempDirectory("zookeeper-", new FileAttribute[0]).toString());
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parseProperties(localProperties);
        this.serverConfig = new ServerConfig();
        this.serverConfig.readFrom(config);
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void start() {
        this.executor.execute(() -> {
            try {
                new ZooKeeperServerMain().runFromConfig(this.serverConfig);
            }
            catch (Exception e) {
                LOG.error("local zookeeper failure.", (Throwable)e);
            }
        });
    }
}

