/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing.expansion;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.expansion.service.ExpansionService;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Partition;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

public class TestExpansionService {
    private static final String TEST_PREFIX_URN = "beam:transforms:xlang:test:prefix";
    private static final String TEST_MULTI_URN = "beam:transforms:xlang:test:multi";
    private static final String TEST_GBK_URN = "beam:transforms:xlang:test:gbk";
    private static final String TEST_CGBK_URN = "beam:transforms:xlang:test:cgbk";
    private static final String TEST_COMGL_URN = "beam:transforms:xlang:test:comgl";
    private static final String TEST_COMPK_URN = "beam:transforms:xlang:test:compk";
    private static final String TEST_FLATTEN_URN = "beam:transforms:xlang:test:flatten";
    private static final String TEST_PARTITION_URN = "beam:transforms:xlang:test:partition";
    private static final String TEST_PARQUET_WRITE_URN = "beam:transforms:xlang:test:parquet_write";
    private static final String TEST_COUNT_URN = "beam:transforms:xlang:count";
    private static final String TEST_FILTER_URN = "beam:transforms:xlang:filter_less_than_eq";
    private static final String TEST_PARQUET_READ_URN = "beam:transforms:xlang:parquet_read";
    private static final String TEST_TEXTIO_READ_URN = "beam:transforms:xlang:textio_read";

    @AutoService(value={ExternalTransformRegistrar.class})
    public static class TestTransformRegistrar
    implements ExternalTransformRegistrar {
        private static String rawSchema = "{ \"type\": \"record\", \"name\": \"testrecord\", \"fields\": [ {\"name\": \"name\", \"type\": \"string\"} ]}";
        private static Schema schema = new Schema.Parser().parse(rawSchema);

        public Map<String, Class<? extends ExternalTransformBuilder<?, ?, ?>>> knownBuilders() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)TestExpansionService.TEST_PREFIX_URN, PrefixBuilder.class);
            builder.put((Object)TestExpansionService.TEST_MULTI_URN, MultiBuilder.class);
            builder.put((Object)TestExpansionService.TEST_GBK_URN, GBKBuilder.class);
            builder.put((Object)TestExpansionService.TEST_COMGL_URN, CombineGloballyBuilder.class);
            builder.put((Object)TestExpansionService.TEST_COMPK_URN, CombinePerKeyBuilder.class);
            builder.put((Object)TestExpansionService.TEST_COUNT_URN, CountBuilder.class);
            builder.put((Object)TestExpansionService.TEST_FILTER_URN, FilterBuilder.class);
            builder.put((Object)TestExpansionService.TEST_PARTITION_URN, PartitionBuilder.class);
            builder.put((Object)TestExpansionService.TEST_PARQUET_WRITE_URN, ParquetWriteBuilder.class);
            builder.put((Object)TestExpansionService.TEST_PARQUET_READ_URN, ParquetReadBuilder.class);
            builder.put((Object)TestExpansionService.TEST_TEXTIO_READ_URN, TextIOReadBuilder.class);
            return builder.build();
        }

        public static class TextIOReadBuilder
        implements ExternalTransformBuilder<StringConfiguration, PBegin, PCollection<String>> {
            public PTransform<PBegin, PCollection<String>> buildExternal(final StringConfiguration configuration) {
                return new PTransform<PBegin, PCollection<String>>(){

                    public PCollection<String> expand(PBegin input) {
                        return (PCollection)input.apply((PTransform)TextIO.read().from(configuration.data));
                    }
                };
            }
        }

        public static class ParquetReadBuilder
        implements ExternalTransformBuilder<StringConfiguration, PBegin, PCollection<GenericRecord>> {
            public PTransform<PBegin, PCollection<GenericRecord>> buildExternal(final StringConfiguration configuration) {
                return new PTransform<PBegin, PCollection<GenericRecord>>(){

                    public PCollection<GenericRecord> expand(PBegin input) {
                        return ((PCollection)((PCollection)((PCollection)input.apply((PTransform)FileIO.match().filepattern(configuration.data))).apply((PTransform)FileIO.readMatches())).apply((PTransform)ParquetIO.readFiles((Schema)schema))).setCoder((Coder)AvroCoder.of((Schema)schema));
                    }
                };
            }
        }

        public static class ParquetWriteBuilder
        implements ExternalTransformBuilder<StringConfiguration, PCollection<GenericRecord>, PCollection<String>> {
            public PTransform<PCollection<GenericRecord>, PCollection<String>> buildExternal(final StringConfiguration configuration) {
                return new PTransform<PCollection<GenericRecord>, PCollection<String>>(){

                    public PCollection<String> expand(PCollection<GenericRecord> input) {
                        return (PCollection)((WriteFilesResult)input.apply((PTransform)FileIO.write().via((FileIO.Sink)ParquetIO.sink((Schema)schema)).to(configuration.data))).getPerDestinationOutputFilenames().apply((PTransform)Values.create());
                    }
                };
            }
        }

        public static class PartitionBuilder
        implements ExternalTransformBuilder<EmptyConfiguration, PCollection<Long>, PCollectionList<Long>> {
            public PTransform<PCollection<Long>, PCollectionList<Long>> buildExternal(EmptyConfiguration configuration) {
                return Partition.of((int)2, (Partition.PartitionFn & Serializable)(elem, numP) -> elem % 2L == 0L ? 0 : 1);
            }
        }

        public static class FilterBuilder
        implements ExternalTransformBuilder<StringConfiguration, PCollection<String>, PCollection<String>> {
            public PTransform<PCollection<String>, PCollection<String>> buildExternal(StringConfiguration configuration) {
                return Filter.lessThanEq((Comparable)((Object)configuration.data));
            }
        }

        public static class CountBuilder
        implements ExternalTransformBuilder<EmptyConfiguration, PCollection<Object>, PCollection<KV<Object, Long>>> {
            public PTransform<PCollection<Object>, PCollection<KV<Object, Long>>> buildExternal(EmptyConfiguration configuration) {
                return Count.perElement();
            }
        }

        public static class CombinePerKeyBuilder
        implements ExternalTransformBuilder<EmptyConfiguration, PCollection<KV<String, Long>>, PCollection<KV<String, Long>>> {
            public PTransform<PCollection<KV<String, Long>>, PCollection<KV<String, Long>>> buildExternal(EmptyConfiguration configuration) {
                return Sum.longsPerKey();
            }
        }

        public static class CombineGloballyBuilder
        implements ExternalTransformBuilder<EmptyConfiguration, PCollection<Long>, PCollection<Long>> {
            public PTransform<PCollection<Long>, PCollection<Long>> buildExternal(EmptyConfiguration configuration) {
                return Sum.longsGlobally();
            }
        }

        public static class GBKBuilder
        implements ExternalTransformBuilder<EmptyConfiguration, PCollection<KV<Long, String>>, PCollection<KV<Long, Iterable<String>>>> {
            public PTransform<PCollection<KV<Long, String>>, PCollection<KV<Long, Iterable<String>>>> buildExternal(EmptyConfiguration configuration) {
                return GroupByKey.create();
            }
        }

        public static class MultiBuilder
        implements ExternalTransformBuilder<EmptyConfiguration, PCollectionTuple, PCollectionTuple> {
            public PTransform<PCollectionTuple, PCollectionTuple> buildExternal(EmptyConfiguration configuration) {
                return new TestMultiPTransform();
            }

            public static class TestMultiPTransform
            extends PTransform<PCollectionTuple, PCollectionTuple> {
                public PCollectionTuple expand(PCollectionTuple input) {
                    final PCollectionView sideView = (PCollectionView)input.get("side").apply((PTransform)View.asSingleton());
                    PCollection main = (PCollection)((PCollection)PCollectionList.of((PCollection)input.get("main1")).and(input.get("main2")).apply((PTransform)Flatten.pCollections())).apply((PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

                        @DoFn.ProcessElement
                        public void processElement(@DoFn.Element String x, DoFn.OutputReceiver<String> out, DoFn.ProcessContext c) {
                            out.output((Object)(x + (String)c.sideInput(sideView)));
                        }
                    }).withSideInputs(new PCollectionView[]{sideView}));
                    PCollection side = (PCollection)input.get("side").apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x + x));
                    return PCollectionTuple.of((String)"main", (PCollection)main).and("side", side);
                }
            }
        }

        public static class PrefixBuilder
        implements ExternalTransformBuilder<StringConfiguration, PCollection<? extends String>, PCollection<String>> {
            public PTransform<PCollection<? extends String>, PCollection<String>> buildExternal(StringConfiguration configuration) {
                return MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> configuration.data + x);
            }
        }

        public static class StringConfiguration
        implements Serializable {
            private String data;

            public void setData(String data) {
                this.data = data;
            }
        }

        public static class EmptyConfiguration {
        }
    }

    @AutoService(value={ExpansionService.ExpansionServiceRegistrar.class})
    public static class TestServiceRegistrar
    implements ExpansionService.ExpansionServiceRegistrar {
        public Map<String, ExpansionService.TransformProvider> knownTransforms() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)TestExpansionService.TEST_CGBK_URN, (Object)new TestCoGroupByKeyTransformProvider());
            builder.put((Object)TestExpansionService.TEST_FLATTEN_URN, (Object)new TestFlattenTransformProvider());
            return builder.build();
        }

        public static class TestFlattenTransformProvider
        implements ExpansionService.TransformProvider<PCollectionList<Long>, PCollection<Long>> {
            public PCollectionList<Long> createInput(Pipeline p, Map<String, PCollection<?>> inputs) {
                PCollectionList inputList = PCollectionList.empty((Pipeline)p);
                for (PCollection<?> collection : inputs.values()) {
                    inputList = inputList.and(collection);
                }
                return inputList;
            }

            public PTransform<PCollectionList<Long>, PCollection<Long>> getTransform(RunnerApi.FunctionSpec spec) {
                return Flatten.pCollections();
            }
        }

        public static class TestCoGroupByKeyTransformProvider
        implements ExpansionService.TransformProvider<KeyedPCollectionTuple<Long>, PCollection<KV<Long, Iterable<String>>>> {
            public KeyedPCollectionTuple<Long> createInput(Pipeline p, Map<String, PCollection<?>> inputs) {
                KeyedPCollectionTuple inputTuple = KeyedPCollectionTuple.empty((Pipeline)p);
                for (Map.Entry<String, PCollection<?>> entry : inputs.entrySet()) {
                    inputTuple = inputTuple.and(new TupleTag(entry.getKey()), entry.getValue());
                }
                return inputTuple;
            }

            public PTransform<KeyedPCollectionTuple<Long>, PCollection<KV<Long, Iterable<String>>>> getTransform(RunnerApi.FunctionSpec spec) {
                return new TestCoGroupByKeyTransform();
            }

            public static class TestCoGroupByKeyTransform
            extends PTransform<KeyedPCollectionTuple<Long>, PCollection<KV<Long, Iterable<String>>>> {
                public PCollection<KV<Long, Iterable<String>>> expand(KeyedPCollectionTuple<Long> input) {
                    ImmutableSet tagSet = ImmutableSet.of((Object)"col1", (Object)"col2");
                    return (PCollection)((PCollection)input.apply((PTransform)CoGroupByKey.create())).apply((PTransform)ParDo.of((DoFn)new DoFn<KV<Long, CoGbkResult>, KV<Long, Iterable<String>>>((Set)tagSet){
                        final /* synthetic */ Set val$tagSet;
                        {
                            this.val$tagSet = set;
                        }

                        @DoFn.ProcessElement
                        public void processElement(@DoFn.Element KV<Long, CoGbkResult> kv, DoFn.OutputReceiver<KV<Long, Iterable<String>>> out) {
                            Iterable iter = () -> this.val$tagSet.stream().flatMap(t -> StreamSupport.stream(((CoGbkResult)kv.getValue()).getAll(t).spliterator(), false)).iterator();
                            out.output((Object)KV.of((Object)((Long)kv.getKey()), iter));
                        }
                    }));
                }
            }
        }
    }
}

