/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion;

import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.runners.core.construction.expansion.ExpansionService;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.ServerBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class TestExpansionService {
    private static final String TEST_COUNT_URN = "beam:transforms:xlang:count";
    private static final String TEST_FILTER_URN = "beam:transforms:xlang:filter_less_than_eq";
    private static final String TEST_PARQUET_READ_URN = "beam:transforms:xlang:parquet_read";
    private static final String TEST_PARQUET_WRITE_URN = "beam:transforms:xlang:parquet_write";

    public static void main(String[] args) throws Exception {
        int port = Integer.parseInt(args[0]);
        System.out.println("Starting expansion service at localhost:" + port);
        Server server = ServerBuilder.forPort((int)port).addService((BindableService)new ExpansionService()).build();
        server.start();
        server.awaitTermination();
    }

    public static class TestTransforms
    implements ExpansionService.ExpansionServiceRegistrar {
        String rawSchema = "{ \"type\": \"record\", \"name\": \"testrecord\", \"fields\": [ {\"name\": \"name\", \"type\": \"string\"} ]}";

        public Map<String, ExpansionService.TransformProvider> knownTransforms() {
            final Schema schema = new Schema.Parser().parse(this.rawSchema);
            return ImmutableMap.of((Object)TestExpansionService.TEST_COUNT_URN, spec -> Count.perElement(), (Object)TestExpansionService.TEST_FILTER_URN, spec -> Filter.lessThanEq((Comparable)Long.valueOf(spec.getPayload().toStringUtf8().charAt(0))), (Object)TestExpansionService.TEST_PARQUET_READ_URN, spec -> new PTransform<PBegin, PCollection<GenericRecord>>(){

                public PCollection<GenericRecord> expand(PBegin input) {
                    return ((PCollection)((PCollection)((PCollection)input.apply((PTransform)FileIO.match().filepattern(spec.getPayload().toStringUtf8()))).apply((PTransform)FileIO.readMatches())).apply((PTransform)ParquetIO.readFiles((Schema)schema))).setCoder((Coder)AvroCoder.of((Schema)schema));
                }
            }, (Object)TestExpansionService.TEST_PARQUET_WRITE_URN, spec -> new PTransform<PCollection<GenericRecord>, PCollection<String>>(){

                public PCollection<String> expand(PCollection<GenericRecord> input) {
                    return (PCollection)((WriteFilesResult)input.apply((PTransform)FileIO.write().via((FileIO.Sink)ParquetIO.sink((Schema)schema)).to(spec.getPayload().toStringUtf8()))).getPerDestinationOutputFilenames().apply((PTransform)Values.create());
                }
            });
        }
    }
}

