/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.metrics;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testutils.metrics.MetricsReader;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MetricsReaderTest {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();
    private static final String NAMESPACE = "Testing";

    @Test
    public void testCounterMetricReceivedFromPipelineResult() {
        List<Integer> sampleInputData = Arrays.asList(1, 1, 1, 1, 1);
        this.createTestPipeline(sampleInputData, new MonitorWithCounter());
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE);
        Assert.assertEquals((long)5L, (long)reader.getCounterMetric("counter", -1L));
    }

    @Test
    public void testStartTimeIsTheMinimumOfTheDistribution() {
        List<Integer> sampleInputData = Arrays.asList(1, 2, 3, 4, 5);
        this.createTestPipeline(sampleInputData, new MonitorWithTimeDistribution());
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE);
        Assert.assertEquals((long)1L, (long)reader.getStartTimeMetric(0L, "timeDist"));
    }

    @Test
    public void testEndTimeIsTheMaximumOfTheDistribution() {
        List<Integer> sampleInputData = Arrays.asList(1, 2, 3, 4, 5);
        this.createTestPipeline(sampleInputData, new MonitorWithTimeDistribution());
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE);
        Assert.assertEquals((long)5L, (long)reader.getEndTimeMetric(0L, "timeDist"));
    }

    @Test
    public void doesntThrowIllegalStateExceptionWhenThereIsNoMetricFound() {
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE);
        reader.getCounterMetric("nonexistent", -1L);
    }

    @Test
    public void testTimeIsMinusOneIfTimeMetricIsTooFarFromNow() {
        List<Integer> sampleInputData = Arrays.asList(1, 5, 5, 5, 5);
        this.createTestPipeline(sampleInputData, new MonitorWithTimeDistribution());
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE);
        Assert.assertEquals((long)-1L, (long)reader.getStartTimeMetric(900000000001L, "timeDist"));
        Assert.assertEquals((long)-1L, (long)reader.getEndTimeMetric(900000000001L, "timeDist"));
    }

    private void createTestPipeline(List<Integer> sampleInputData, DoFn<Integer, Integer> monitor) {
        ((PCollection)this.testPipeline.apply((PTransform)Create.of(sampleInputData))).apply((PTransform)ParDo.of(monitor));
    }

    private static class MonitorWithTimeDistribution
    extends DoFn<Integer, Integer> {
        private final Distribution timeDistribution = Metrics.distribution((String)"Testing", (String)"timeDist");

        private MonitorWithTimeDistribution() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            this.timeDistribution.update(((Integer)c.element()).longValue());
        }
    }

    private static class MonitorWithCounter
    extends DoFn<Integer, Integer> {
        private final Counter elementCounter = Metrics.counter((String)"Testing", (String)"counter");

        private MonitorWithCounter() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            this.elementCounter.inc();
        }
    }
}

