/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.metrics;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testutils.metrics.MetricsReader;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MetricsReaderTest {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();
    private static final String NAMESPACE = "Testing";

    @Test
    public void testCounterMetricReceivedFromPipelineResult() {
        List<Integer> sampleInputData = Arrays.asList(1, 1, 1, 1, 1);
        this.createTestPipeline(sampleInputData, new MonitorWithCounter());
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE);
        Assert.assertEquals((long)5L, (long)reader.getCounterMetric("counter"));
    }

    @Test
    public void testStartTimeIsTheMinimumFromAllCollectedDistributions() {
        List<Integer> sampleInputData = Arrays.asList(1, 2, 3, 4, 5);
        this.createTestPipelineWithBranches(sampleInputData);
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE, 0L);
        Assert.assertEquals((long)1L, (long)reader.getStartTimeMetric("timeDist"));
    }

    @Test
    public void testEndTimeIsTheMaximumOfAllCollectedDistributions() {
        List<Integer> sampleInputData = Arrays.asList(1, 2, 3, 4, 5);
        this.createTestPipelineWithBranches(sampleInputData);
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE, 0L);
        Assert.assertEquals((long)10L, (long)reader.getEndTimeMetric("timeDist"));
    }

    private void createTestPipelineWithBranches(List<Integer> sampleInputData) {
        PCollection inputData = (PCollection)this.testPipeline.apply((PTransform)Create.of(sampleInputData));
        inputData.apply("Monitor #1", (PTransform)ParDo.of((DoFn)new MonitorWithTimeDistribution()));
        ((PCollection)inputData.apply("Multiply input", (PTransform)MapElements.via((SimpleFunction)new MultiplyElements()))).apply("Monitor #2", (PTransform)ParDo.of((DoFn)new MonitorWithTimeDistribution()));
    }

    @Test
    public void doesntThrowIllegalStateExceptionWhenThereIsNoMetricFound() {
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE);
        reader.getCounterMetric("nonexistent");
    }

    @Test
    public void testTimeIsMinusOneIfTimeMetricIsTooFarFromNow() {
        List<Integer> sampleInputData = Arrays.asList(1, 5, 5, 5, 5);
        this.createTestPipeline(sampleInputData, new MonitorWithTimeDistribution());
        PipelineResult result = this.testPipeline.run();
        MetricsReader reader = new MetricsReader(result, NAMESPACE, 900000000001L);
        Assert.assertEquals((long)-1L, (long)reader.getStartTimeMetric("timeDist"));
        Assert.assertEquals((long)-1L, (long)reader.getEndTimeMetric("timeDist"));
    }

    private void createTestPipeline(List<Integer> sampleInputData, DoFn<Integer, Integer> monitor) {
        ((PCollection)this.testPipeline.apply((PTransform)Create.of(sampleInputData))).apply((PTransform)ParDo.of(monitor));
    }

    private static class MultiplyElements
    extends SimpleFunction<Integer, Integer> {
        private MultiplyElements() {
        }

        public Integer apply(Integer input) {
            return input * 2;
        }
    }

    private static class MonitorWithTimeDistribution
    extends DoFn<Integer, Integer> {
        private final Distribution timeDistribution = Metrics.distribution((String)"Testing", (String)"timeDist");

        private MonitorWithTimeDistribution() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            this.timeDistribution.update(((Integer)c.element()).longValue());
        }
    }

    private static class MonitorWithCounter
    extends DoFn<Integer, Integer> {
        private final Counter elementCounter = Metrics.counter((String)"Testing", (String)"counter");

        private MonitorWithCounter() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            this.elementCounter.inc();
        }
    }
}

