/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.publishing;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.sdk.testutils.publishing.AutoValue_InfluxDBPublisher_DataPoint;
import org.apache.beam.sdk.testutils.publishing.InfluxDBSettings;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfluxDBPublisher {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(InfluxDBPublisher.class);

    private InfluxDBPublisher() {
    }

    public static @UnknownKeyFor @NonNull @Initialized DataPoint dataPoint(@UnknownKeyFor @NonNull @Initialized String measurement, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tags, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Number> fields, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Long timestampSecs) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)measurement), (Object)"Measurement cannot be blank");
        return new AutoValue_InfluxDBPublisher_DataPoint(measurement, tags, fields, timestampSecs, TimeUnit.SECONDS);
    }

    public static @UnknownKeyFor @NonNull @Initialized DataPoint dataPoint(@UnknownKeyFor @NonNull @Initialized String measurement, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tags, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Number> fields, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Long timestamp, @UnknownKeyFor @NonNull @Initialized TimeUnit timestampUnit) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)measurement), (Object)"Measurement cannot be blank");
        return new AutoValue_InfluxDBPublisher_DataPoint(measurement, tags, fields, timestamp, timestampUnit);
    }

    @Deprecated
    public static void publishNexmarkResults(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> results, @UnknownKeyFor @NonNull @Initialized InfluxDBSettings settings, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tags) {
        InfluxDBPublisher.publishWithCheck(settings, InfluxDBPublisher.nexmarkDataPoints(results, tags));
    }

    public static void publishWithSettings(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized NamedTestResult> results, @UnknownKeyFor @NonNull @Initialized InfluxDBSettings settings) {
        if (StringUtils.isNotBlank((CharSequence)settings.measurement)) {
            Collection dataPoints = Collections2.transform(results, res -> res.toInfluxDBDataPoint(settings.measurement));
            InfluxDBPublisher.publish(settings, dataPoints);
        } else {
            LOG.warn("Missing setting InfluxDB measurement. Metrics won't be published.");
        }
    }

    public static void publish(@UnknownKeyFor @NonNull @Initialized InfluxDBSettings settings, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized DataPoint> dataPoints) {
        StringBuilder builder = new StringBuilder();
        dataPoints.forEach(m -> ((DataPoint)m).append(builder).append('\n'));
        InfluxDBPublisher.publishWithCheck(settings, builder.toString());
    }

    private static void publishWithCheck(@UnknownKeyFor @NonNull @Initialized InfluxDBSettings settings, @UnknownKeyFor @NonNull @Initialized String data) {
        Objects.requireNonNull(settings, "InfluxDB settings must not be null");
        if (StringUtils.isNotBlank((CharSequence)settings.database)) {
            try {
                HttpClientBuilder builder = InfluxDBPublisher.provideHttpBuilder(settings);
                HttpPost postRequest = InfluxDBPublisher.providePOSTRequest(settings);
                postRequest.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new ByteArrayEntity(data.getBytes(StandardCharsets.UTF_8))));
                InfluxDBPublisher.executeWithVerification(postRequest, builder);
            }
            catch (Exception exception) {
                LOG.warn("Unable to publish metrics due to error: {}", (Object)exception.getMessage());
            }
        } else {
            LOG.warn("Missing setting InfluxDB database. Metrics won't be published.");
        }
    }

    @Deprecated
    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String nexmarkDataPoints(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> results, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tags) {
        StringBuilder builder = new StringBuilder();
        ImmutableSet fields = ImmutableSet.of((Object)"runtimeMs", (Object)"numResults");
        results.forEach(arg_0 -> InfluxDBPublisher.lambda$nexmarkDataPoints$2(builder, tags, (Set)fields, arg_0));
        return builder.toString();
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized Map<K, V> filterKeys(@UnknownKeyFor @NonNull @Initialized Map<K, V> map, @UnknownKeyFor @NonNull @Initialized Set<K> keys) {
        return Maps.filterKeys(map, keys::contains);
    }

    private static @UnknownKeyFor @NonNull @Initialized StringBuilder addMeasurement(@UnknownKeyFor @NonNull @Initialized StringBuilder builder, @UnknownKeyFor @NonNull @Initialized String measurement, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> tags, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> fields, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Object timestampSecs) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!fields.isEmpty() ? 1 : 0) != 0, (Object)"fields cannot be empty");
        builder.append(measurement);
        tags.forEach((k, v) -> builder.append(',').append((String)k).append('=').append(v));
        builder.append(' ');
        fields.forEach((k, v) -> builder.append((String)k).append('=').append(InfluxDBPublisher.fieldValue(v)).append(','));
        builder.setLength(builder.length() - 1);
        if (timestampSecs != null) {
            builder.append(' ').append(timestampSecs);
        }
        return builder;
    }

    private static @UnknownKeyFor @NonNull @Initialized String fieldValue(@javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Object value) {
        Preconditions.checkStateNotNull((Object)value, (Object)"field value cannot be null");
        return value instanceof Integer || value instanceof Long ? value + "i" : value.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized HttpClientBuilder provideHttpBuilder(@UnknownKeyFor @NonNull @Initialized InfluxDBSettings settings) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{settings.userName, settings.userPassword})) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(settings.userName, settings.userPassword));
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        return builder;
    }

    private static @UnknownKeyFor @NonNull @Initialized HttpPost providePOSTRequest(@UnknownKeyFor @NonNull @Initialized InfluxDBSettings settings) {
        String retentionPolicy = "rp" + (StringUtils.isBlank((CharSequence)settings.retentionPolicy) ? "" : "=" + settings.retentionPolicy);
        return new HttpPost(settings.host + "/write?db=" + settings.database + "&" + retentionPolicy + "&precision=s");
    }

    private static void executeWithVerification(@UnknownKeyFor @NonNull @Initialized HttpPost postRequest, @UnknownKeyFor @NonNull @Initialized HttpClientBuilder builder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (CloseableHttpResponse response = builder.build().execute((HttpUriRequest)postRequest);){
            InfluxDBPublisher.is2xx((HttpResponse)response);
        }
    }

    private static void is2xx(@UnknownKeyFor @NonNull @Initialized HttpResponse response) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code < 200 || code >= 300) {
            throw new IOException("Response code: " + code + ". Reason: " + InfluxDBPublisher.getErrorMessage(response.getEntity()));
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String getErrorMessage(@UnknownKeyFor @NonNull @Initialized HttpEntity entity) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Header encodingHeader = entity.getContentEncoding();
        Charset encoding = encodingHeader == null ? StandardCharsets.UTF_8 : Charsets.toCharset((String)encodingHeader.getValue());
        JsonElement errorElement = ((JsonObject)new Gson().fromJson(EntityUtils.toString((HttpEntity)entity, (Charset)encoding), JsonObject.class)).get("error");
        return Objects.isNull(errorElement) ? "[Unable to get error message]" : errorElement.toString();
    }

    private static /* synthetic */ void lambda$nexmarkDataPoints$2(StringBuilder builder, Map tags, Set fields, Map map) {
        String measurement = Preconditions.checkArgumentNotNull(map.get("measurement")).toString();
        InfluxDBPublisher.addMeasurement(builder, measurement, tags, InfluxDBPublisher.filterKeys(map, fields), map.get("timestamp")).append('\n');
    }

    @AutoValue
    public static abstract class DataPoint {
        DataPoint() {
        }

        @Pure
        public abstract @UnknownKeyFor @NonNull @Initialized String measurement();

        @Pure
        public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tags();

        @Pure
        public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Number> fields();

        @javax.annotation.Nullable
        @Pure
        public abstract @UnknownKeyFor @Nullable @Initialized Long timestamp();

        @Pure
        public abstract @UnknownKeyFor @NonNull @Initialized TimeUnit timestampUnit();

        @SideEffectFree
        public final @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.append(new StringBuilder()).toString();
        }

        @javax.annotation.Nullable
        private @UnknownKeyFor @Nullable @Initialized Long timestampSecs() {
            return this.timestamp() != null ? Long.valueOf(this.timestampUnit().toSeconds(this.timestamp())) : null;
        }

        private @UnknownKeyFor @NonNull @Initialized StringBuilder append(@UnknownKeyFor @NonNull @Initialized StringBuilder builder) {
            return InfluxDBPublisher.addMeasurement(builder, this.measurement(), this.tags(), this.fields(), this.timestampSecs());
        }
    }
}

