/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.publishing;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.sdk.testutils.publishing.InfluxDBPublisher;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;

public final class InfluxDBPublisherTest {
    @Test
    public void testNexmarkDataPoints() {
        ImmutableMap measurement = ImmutableMap.builder().put((Object)"measurement", (Object)"name").put((Object)"timestamp", (Object)9999L).put((Object)"runtimeMs", (Object)"1000i").put((Object)"numResults", (Object)"10i").build();
        ImmutableList measurements = ImmutableList.of((Object)measurement, (Object)measurement, (Object)measurement);
        ImmutableMap tags = ImmutableMap.of((Object)"runner", (Object)"test", (Object)"tag", (Object)"value");
        String actual = InfluxDBPublisher.nexmarkDataPoints((Collection)measurements, (Map)tags);
        String expected = "name,runner=test,tag=value runtimeMs=1000i,numResults=10i 9999\n";
        Assert.assertEquals((Object)(expected + expected + expected), (Object)actual);
    }

    @Test
    public void testNamedTestResultToDataPoint() {
        NamedTestResult result = NamedTestResult.create((String)"id1", (String)"9999", (String)"metric1", (double)100.0);
        String actual = result.toInfluxDBDataPoint("name").toString();
        String expected = "name,test_id=id1,metric=metric1 value=100.0";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDataPointToString() {
        ImmutableMap tags = ImmutableMap.of((Object)"tag1", (Object)"t1", (Object)"tag2", (Object)"t2");
        ImmutableMap fields = ImmutableMap.of((Object)"integer", (Object)100, (Object)"float", (Object)100.0);
        Assert.assertEquals((Object)"m1,tag1=t1,tag2=t2 integer=100i,float=100.0 999", (Object)InfluxDBPublisher.dataPoint((String)"m1", (Map)tags, (Map)fields, (Long)999L).toString());
        Assert.assertEquals((Object)"m1,tag1=t1,tag2=t2 integer=100i,float=100.0", (Object)InfluxDBPublisher.dataPoint((String)"m1", (Map)tags, (Map)fields, null).toString());
    }
}

