/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.jvmverification;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.repackaged.core.org.apache.commons.compress.utils.IOUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.commons.codec.binary.Hex;
import org.junit.Assert;
import org.junit.Test;

public class JvmVerification {
    private static final Map<String, Java> versionMapping = new HashMap<String, Java>();

    @Test
    public void verifyCodeIsCompiledWithJava8() throws IOException {
        Assert.assertEquals((Object)((Object)Java.v1_8), (Object)((Object)JvmVerification.getByteCodeVersion(DoFn.class)));
    }

    @Test
    public void verifyTestCodeIsCompiledWithJava8() throws IOException {
        Assert.assertEquals((Object)((Object)Java.v1_8), (Object)((Object)JvmVerification.getByteCodeVersion(JvmVerification.class)));
    }

    @Test
    public void verifyTestCodeIsCompiledWithJava11() throws IOException {
        Assert.assertEquals((Object)((Object)Java.v11), (Object)((Object)JvmVerification.getByteCodeVersion(JvmVerification.class)));
    }

    @Test
    public void verifyTestCodeIsCompiledWithJava17() throws IOException {
        Assert.assertEquals((Object)((Object)Java.v17), (Object)((Object)JvmVerification.getByteCodeVersion(JvmVerification.class)));
    }

    @Test
    public void verifyTestCodeIsCompiledWithJava21() throws IOException {
        Assert.assertEquals((Object)((Object)Java.v21), (Object)((Object)JvmVerification.getByteCodeVersion(JvmVerification.class)));
    }

    @Test
    public void verifyRunningJVMVersionIs11() {
        String version = JvmVerification.getJavaSpecification();
        Assert.assertEquals((Object)Java.v11.name, (Object)version);
    }

    @Test
    public void verifyRunningJVMVersionIs17() {
        String version = JvmVerification.getJavaSpecification();
        Assert.assertEquals((Object)Java.v17.name, (Object)version);
    }

    @Test
    public void verifyRunningJVMVersionIs21() {
        String version = JvmVerification.getJavaSpecification();
        Assert.assertEquals((Object)Java.v21.name, (Object)version);
    }

    private static <T> Java getByteCodeVersion(Class<T> clazz) throws IOException {
        InputStream stream = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace(".", "/") + ".class");
        byte[] classBytes = IOUtils.toByteArray((InputStream)stream);
        String versionInHexString = Hex.encodeHexString((byte[])new byte[]{classBytes[6], classBytes[7]});
        return versionMapping.get(versionInHexString);
    }

    private static String getJavaSpecification() {
        return System.getProperty("java.specification.version");
    }

    static {
        versionMapping.put("0034", Java.v1_8);
        versionMapping.put("0037", Java.v11);
        versionMapping.put("003d", Java.v17);
        versionMapping.put("0041", Java.v21);
    }

    static enum Java {
        v1_8("1.8"),
        v11("11"),
        v17("17"),
        v21("21");

        final String name;

        private Java(String name) {
            this.name = name;
        }
    }
}

