/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.publishing;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.sdk.testutils.publishing.AutoValue_InfluxDBPublisher_DataPoint;
import org.apache.beam.sdk.testutils.publishing.InfluxDBSettings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfluxDBPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDBPublisher.class);

    private InfluxDBPublisher() {
    }

    public static DataPoint dataPoint(String measurement, Map<String, String> tags, Map<String, Number> fields, @Nullable Long timestampSecs) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)measurement), (Object)"Measurement cannot be blank");
        return new AutoValue_InfluxDBPublisher_DataPoint(measurement, tags, fields, timestampSecs, TimeUnit.SECONDS);
    }

    public static DataPoint dataPoint(String measurement, Map<String, String> tags, Map<String, Number> fields, @Nullable Long timestamp, TimeUnit timestampUnit) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)measurement), (Object)"Measurement cannot be blank");
        return new AutoValue_InfluxDBPublisher_DataPoint(measurement, tags, fields, timestamp, timestampUnit);
    }

    @Deprecated
    public static void publishNexmarkResults(Collection<Map<String, Object>> results, InfluxDBSettings settings, Map<String, String> tags) {
        InfluxDBPublisher.publishWithCheck(settings, InfluxDBPublisher.nexmarkDataPoints(results, tags));
    }

    public static void publishWithSettings(Collection<NamedTestResult> results, InfluxDBSettings settings) {
        if (StringUtils.isNotBlank((CharSequence)settings.measurement)) {
            Collection dataPoints = Collections2.transform(results, res -> res.toInfluxDBDataPoint(settings.measurement));
            InfluxDBPublisher.publish(settings, dataPoints);
        } else {
            LOG.warn("Missing setting InfluxDB measurement. Metrics won't be published.");
        }
    }

    public static void publish(InfluxDBSettings settings, Collection<DataPoint> dataPoints) {
        StringBuilder builder = new StringBuilder();
        dataPoints.forEach(m -> ((DataPoint)m).append(builder).append('\n'));
        InfluxDBPublisher.publishWithCheck(settings, builder.toString());
    }

    private static void publishWithCheck(InfluxDBSettings settings, String data) {
        Objects.requireNonNull(settings, "InfluxDB settings must not be null");
        if (StringUtils.isNotBlank((CharSequence)settings.database)) {
            try {
                HttpClientBuilder builder = InfluxDBPublisher.provideHttpBuilder(settings);
                HttpPost postRequest = InfluxDBPublisher.providePOSTRequest(settings);
                postRequest.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new ByteArrayEntity(data.getBytes(StandardCharsets.UTF_8))));
                InfluxDBPublisher.executeWithVerification(postRequest, builder);
            }
            catch (Exception exception) {
                LOG.warn("Unable to publish metrics due to error: {}", (Object)exception.getMessage());
            }
        } else {
            LOG.warn("Missing setting InfluxDB database. Metrics won't be published.");
        }
    }

    @Deprecated
    @VisibleForTesting
    static String nexmarkDataPoints(Collection<Map<String, Object>> results, Map<String, String> tags) {
        StringBuilder builder = new StringBuilder();
        ImmutableSet fields = ImmutableSet.of((Object)"runtimeMs", (Object)"numResults");
        results.forEach(arg_0 -> InfluxDBPublisher.lambda$nexmarkDataPoints$2(builder, tags, (Set)fields, arg_0));
        return builder.toString();
    }

    private static <K, V> Map<K, V> filterKeys(Map<K, V> map, Set<K> keys) {
        return Maps.filterKeys(map, keys::contains);
    }

    private static StringBuilder addMeasurement(StringBuilder builder, String measurement, Map<String, ?> tags, Map<String, ?> fields, @Nullable Object timestampSecs) {
        Preconditions.checkState((!fields.isEmpty() ? 1 : 0) != 0, (Object)"fields cannot be empty");
        builder.append(measurement);
        tags.forEach((k, v) -> builder.append(',').append((String)k).append('=').append(v));
        builder.append(' ');
        fields.forEach((k, v) -> builder.append((String)k).append('=').append(InfluxDBPublisher.fieldValue(v)).append(','));
        builder.setLength(builder.length() - 1);
        if (timestampSecs != null) {
            builder.append(' ').append(timestampSecs);
        }
        return builder;
    }

    private static String fieldValue(@Nullable Object value) {
        org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)value, (Object)"field value cannot be null");
        return value instanceof Integer || value instanceof Long ? value + "i" : value.toString();
    }

    private static HttpClientBuilder provideHttpBuilder(InfluxDBSettings settings) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{settings.userName, settings.userPassword})) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(settings.userName, settings.userPassword));
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        return builder;
    }

    private static HttpPost providePOSTRequest(InfluxDBSettings settings) {
        String retentionPolicy = "rp" + (StringUtils.isBlank((CharSequence)settings.retentionPolicy) ? "" : "=" + settings.retentionPolicy);
        return new HttpPost(settings.host + "/write?db=" + settings.database + "&" + retentionPolicy + "&precision=s");
    }

    private static void executeWithVerification(HttpPost postRequest, HttpClientBuilder builder) throws IOException {
        try (CloseableHttpResponse response = builder.build().execute((HttpUriRequest)postRequest);){
            InfluxDBPublisher.is2xx((HttpResponse)response);
        }
    }

    private static void is2xx(HttpResponse response) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code < 200 || code >= 300) {
            throw new IOException("Response code: " + code + ". Reason: " + InfluxDBPublisher.getErrorMessage(response.getEntity()));
        }
    }

    private static String getErrorMessage(HttpEntity entity) throws IOException {
        Header encodingHeader = entity.getContentEncoding();
        Charset encoding = encodingHeader == null ? StandardCharsets.UTF_8 : Charsets.toCharset((String)encodingHeader.getValue());
        JsonElement errorElement = ((JsonObject)new Gson().fromJson(EntityUtils.toString((HttpEntity)entity, (Charset)encoding), JsonObject.class)).get("error");
        return Objects.isNull(errorElement) ? "[Unable to get error message]" : errorElement.toString();
    }

    private static /* synthetic */ void lambda$nexmarkDataPoints$2(StringBuilder builder, Map tags, Set fields, Map map) {
        String measurement = org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull(map.get("measurement")).toString();
        InfluxDBPublisher.addMeasurement(builder, measurement, tags, InfluxDBPublisher.filterKeys(map, fields), map.get("timestamp")).append('\n');
    }

    @AutoValue
    public static abstract class DataPoint {
        DataPoint() {
        }

        @Pure
        public abstract String measurement();

        @Pure
        public abstract Map<String, String> tags();

        @Pure
        public abstract Map<String, Number> fields();

        @Nullable
        @Pure
        public abstract Long timestamp();

        @Pure
        public abstract TimeUnit timestampUnit();

        public final String toString() {
            return this.append(new StringBuilder()).toString();
        }

        @Nullable
        private Long timestampSecs() {
            return this.timestamp() != null ? Long.valueOf(this.timestampUnit().toSeconds(this.timestamp())) : null;
        }

        private StringBuilder append(StringBuilder builder) {
            return InfluxDBPublisher.addMeasurement(builder, this.measurement(), this.tags(), this.fields(), this.timestampSecs());
        }
    }
}

