/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.publishing;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BigQueryClient {
    private static final BigQuery.TableOption FIELD_OPTIONS = BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[]{BigQuery.TableField.TYPE});
    private BigQuery client;
    private String projectId;
    private String dataset;

    protected BigQueryClient(BigQuery client, String projectId, String dataset) {
        this.client = client;
        this.projectId = projectId;
        this.dataset = dataset;
    }

    public static BigQueryClient create(String dataset) {
        BigQueryOptions options = BigQueryOptions.newBuilder().build();
        return new BigQueryClient((BigQuery)options.getService(), options.getProjectId(), dataset);
    }

    private void createTable(TableId tableId, Schema schema) {
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)schema)).setFriendlyName(tableId.getTable()).build();
        this.client.create(tableInfo, new BigQuery.TableOption[]{FIELD_OPTIONS});
    }

    public void insertRow(Map<String, ?> row, Map<String, String> schema, String table) {
        this.createTableIfNotExists(table, schema);
        this.insertRow(row, table);
    }

    public void insertRow(Map<String, ?> row, String table) {
        this.insertAll(Collections.singletonList(row), table);
    }

    public void insertAll(Collection<Map<String, ?>> rows, Map<String, String> schema, String table) {
        this.createTableIfNotExists(table, schema);
        this.insertAll(rows, table);
    }

    public void insertAll(Collection<Map<String, ?>> rows, String table) {
        TableId tableId = TableId.of((String)this.projectId, (String)this.dataset, (String)table);
        InsertAllRequest.Builder builder = InsertAllRequest.newBuilder((TableId)tableId);
        for (Map<String, ?> row : rows) {
            builder.addRow(row);
        }
        InsertAllResponse response = this.client.insertAll(builder.build());
        this.handleBigQueryResponseExceptions(response);
    }

    private void handleBigQueryResponseExceptions(InsertAllResponse response) {
        if (response.hasErrors()) {
            throw new RuntimeException(String.format("The following errors occurred while inserting to BigQuery: %s", response.getInsertErrors()));
        }
    }

    public void createTableIfNotExists(String tableName, Map<String, String> schema) {
        TableId tableId = TableId.of((String)this.projectId, (String)this.dataset, (String)tableName);
        if (this.client.getTable(tableId, new BigQuery.TableOption[]{FIELD_OPTIONS}) == null) {
            List schemaFields = schema.entrySet().stream().map(entry -> Field.of((String)((String)entry.getKey()), (LegacySQLTypeName)LegacySQLTypeName.valueOf((String)((String)entry.getValue())), (Field[])new Field[0])).collect(Collectors.toList());
            this.createTable(tableId, Schema.of(schemaFields));
        }
    }
}

