/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.metrics;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.sdk.testutils.metrics.MetricsReader;
import org.apache.beam.sdk.testutils.publishing.ConsoleResultPublisher;
import org.apache.beam.sdk.testutils.publishing.InfluxDBPublisher;
import org.apache.beam.sdk.testutils.publishing.InfluxDBSettings;

public class IOITMetrics {
    private final Set<Function<MetricsReader, NamedTestResult>> metricSuppliers;
    private final PipelineResult result;
    private final String namespace;
    private final String uuid;
    private final String timestamp;

    public IOITMetrics(Set<Function<MetricsReader, NamedTestResult>> metricSuppliers, PipelineResult result, String namespace, String uuid, String timestamp) {
        this.metricSuppliers = metricSuppliers;
        this.result = result;
        this.namespace = namespace;
        this.uuid = uuid;
        this.timestamp = timestamp;
    }

    public void publishToInflux(InfluxDBSettings settings) {
        MetricsReader reader = new MetricsReader(this.result, this.namespace);
        Collection<NamedTestResult> namedTestResults = reader.readAll(this.metricSuppliers);
        IOITMetrics.publishToInflux(this.uuid, this.timestamp, namedTestResults, settings);
    }

    public static void publishToInflux(String uuid, String timestamp, Collection<NamedTestResult> results, InfluxDBSettings settings) {
        ConsoleResultPublisher.publish(results, uuid, timestamp);
        InfluxDBPublisher.publishWithSettings(results, settings);
    }
}

