/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.jmh;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.beam.sdk.testutils.publishing.InfluxDBPublisher;
import org.apache.beam.sdk.testutils.publishing.InfluxDBSettings;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.CommandLineOptionException;
import org.openjdk.jmh.runner.options.CommandLineOptions;
import org.openjdk.jmh.runner.options.Options;

public class Main {
    private static final String INFLUXDB_HOST = "INFLUXDB_HOST";
    private static final String INFLUXDB_DATABASE = "INFLUXDB_DATABASE";
    private static final String INFLUXDB_BASE_MEASUREMENT = "INFLUXDB_BASE_MEASUREMENT";

    public static void main(String[] args) throws CommandLineOptionException, IOException, RunnerException {
        CommandLineOptions opts = new CommandLineOptions(args);
        InfluxDBSettings influxDB = Main.influxDBSettings();
        String baseMeasurement = System.getenv(INFLUXDB_BASE_MEASUREMENT);
        if (influxDB == null || baseMeasurement == null || Main.isSingleShotTimeOnly(opts.getBenchModes()) || opts.shouldHelp() || opts.shouldList() || opts.shouldListWithParams() || opts.shouldListProfilers() || opts.shouldListResultFormats()) {
            org.openjdk.jmh.Main.main((String[])args);
            return;
        }
        Runner runner = new Runner((Options)opts);
        Collection results = runner.run();
        Collection dataPoints = results.stream().filter(r -> r.getParams().getMode() != Mode.SingleShotTime).map(r -> Main.dataPoint(baseMeasurement, r)).collect(Collectors.toList());
        InfluxDBPublisher.publish(influxDB, dataPoints);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSingleShotTimeOnly(Collection<Mode> modes) {
        if (modes.isEmpty()) return false;
        if (!modes.stream().allMatch(arg_0 -> Mode.SingleShotTime.equals(arg_0))) return false;
        return true;
    }

    private static InfluxDBPublisher.DataPoint dataPoint(String baseMeasurement, RunResult run) {
        BenchmarkParams params = run.getParams();
        Result result = run.getPrimaryResult();
        long startTimeMs = Main.metaDataStream(run).mapToLong(BenchmarkResultMetaData::getStartTime).min().getAsLong();
        long stopTimeMs = Main.metaDataStream(run).mapToLong(BenchmarkResultMetaData::getStopTime).max().getAsLong();
        String measurement = String.format("%s_%s", baseMeasurement, params.getMode().shortLabel());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("benchmark", params.getBenchmark());
        tags.put("scoreUnit", result.getScoreUnit());
        tags.putAll(params.getParamsKeys().stream().collect(Collectors.toMap(Function.identity(), x$0 -> params.getParam(x$0))));
        HashMap<String, Number> fields = new HashMap<String, Number>();
        fields.put("score", result.getScore());
        fields.put("scoreMean", result.getStatistics().getMean());
        fields.put("scoreMedian", result.getStatistics().getPercentile(0.5));
        if (!Double.isNaN(result.getScoreError())) {
            fields.put("scoreError", result.getScoreError());
        }
        fields.put("sampleCount", result.getSampleCount());
        fields.put("durationMs", stopTimeMs - startTimeMs);
        return InfluxDBPublisher.dataPoint(measurement, tags, fields, startTimeMs, TimeUnit.MILLISECONDS);
    }

    private static Stream<BenchmarkResultMetaData> metaDataStream(RunResult runResult) {
        return runResult.getBenchmarkResults().stream().map(BenchmarkResult::getMetadata).filter(Objects::nonNull);
    }

    @Nullable
    private static InfluxDBSettings influxDBSettings() {
        String host = System.getenv(INFLUXDB_HOST);
        String database = System.getenv(INFLUXDB_DATABASE);
        if (database == null) {
            return null;
        }
        InfluxDBSettings.Builder builder = InfluxDBSettings.builder();
        if (host != null) {
            builder.withHost(host);
        }
        return builder.withDatabase(database).get();
    }
}

